/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomPersonAddress;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.PersonAddressExpression;
import eelk.koguja.search.PersonAddressResult;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.SQLException;
import java.util.List;

public class MPersonAddress
extends Model<DomPersonAddress, PersonAddressExpression, PersonAddressResult> {
    private static MPersonAddress theInstance;

    private MPersonAddress() {
    }

    public static MPersonAddress instance() {
        if (theInstance == null) {
            theInstance = new MPersonAddress();
        }
        return theInstance;
    }

    @Override
    public int create(DomPersonAddress address) throws SQLException {
        String sql = "{? = call create_person_address(?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        if (address.getPersonId() == null) {
            cs.setNull(2, 4);
        } else {
            cs.setInt(2, (int)address.getPersonId());
        }
        cs.setInt(3, (int)address.getAddressId());
        cs.setDate(4, address.getValidFrom());
        cs.setDate(5, address.getValidTo());
        cs.setInt(6, Session.congregation().getId());
        cs.execute();
        address.setId(cs.getObject(1) == null ? -1 : cs.getInt(1));
        cs.close();
        return address.getId();
    }

    @Override
    public DomPersonAddress get(int objectID) throws SQLException, ObjectNotFound {
        return null;
    }

    @Override
    public void modify(DomPersonAddress address) throws SQLException {
        String sql = "{call modify_person_address(?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, address.getId());
        cs.setDate(2, address.getValidFrom());
        cs.setDate(3, address.getValidTo());
        cs.setInt(4, (int)address.getPersonId());
        cs.setInt(5, Session.congregation().getId());
        cs.execute();
        cs.close();
    }

    @Override
    public void delete(int addressId) throws SQLException {
        String sql = "{call delete_person_address(?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, addressId);
        cs.setInt(2, Session.congregation().getId());
        cs.execute();
        cs.close();
    }

    public void modifyAll(int addressId, Date validFrom, Date validTo) throws SQLException {
        String sql = "{call modify_persons_addresses(?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, addressId);
        cs.setDate(2, validFrom);
        cs.setDate(3, validTo);
        cs.setInt(4, Session.congregation().getId());
        cs.execute();
        cs.close();
    }

    public void changePerson(int oldPersonId, int newPersonId) {
        String sql = "{call modify_address_person(?, ?)}";
        try {
            CallableStatement cs = Session.prepareCall(sql);
            cs.setInt(1, oldPersonId);
            cs.setInt(2, newPersonId);
            cs.execute();
            cs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<PersonAddressResult> search(PersonAddressExpression expression) throws SQLException {
        return null;
    }
}

