/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.MPersonAddress;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomAttribute;
import eelk.koguja.model.DomCongregationPerson;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomPersonAddress;
import eelk.koguja.model.DomPersonEventHistory;
import eelk.koguja.model.DomPersonHistory;
import eelk.koguja.model.DomPersonWithRelationType;
import eelk.koguja.model.DomShortEvent;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.PersonExpression;
import eelk.koguja.search.PersonResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MPerson
extends Model<DomPerson, PersonExpression, PersonResult> {
    private static MPerson theInstance;

    protected MPerson() {
    }

    public static MPerson instance() {
        if (theInstance == null) {
            theInstance = new MPerson();
        }
        return theInstance;
    }

    public static List<DomPerson> listPublicPersons(String firstName, String lastName, Date date, String code, boolean all) throws SQLException {
        if (!all) {
            firstName = "%" + Util.d(firstName) + "%";
            lastName = "%" + Util.d(lastName) + "%";
        }
        String sql = "SELECT id, firstname, lastname, birthdate, deathdate, code, sex FROM " + (all ? "f_search_all_persons(?, ?, ?, ?, ?)" : "f_search_cong_access_persons(?, ?, ?, ?, ?, ?)");
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setString(1, firstName);
        ps.setString(2, lastName);
        ps.setDate(3, date);
        ps.setString(4, code);
        ps.setNull(5, 4);
        if (!all) {
            ps.setInt(6, Session.congregation().getId());
        }
        ResultSet rs = ps.executeQuery();
        List<DomPerson> lst = MPerson.fromResultSet(rs, Util.createStringSet("id", "firstname", "lastname", "birthdate", "deathdate", "code", "sex"));
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomPerson> listPublicPersons() throws SQLException {
        return MPerson.listPublicPersons("%", "%", null, "%", true);
    }

    public static List<DomPerson> listPublicPersonsWithAddress(Integer address_id) throws SQLException {
        String sql = "SELECT id, firstname, lastname FROM f_get_address_persons(?);";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, address_id);
        ResultSet rs = ps.executeQuery();
        List<DomPerson> lst = MPerson.fromResultSet(rs, Util.createStringSet("id", "firstname", "lastname"));
        rs.close();
        ps.close();
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DomCongregationPerson> listCongregationPersons(int PersonId, boolean authorized) throws SQLException {
        ArrayList<DomCongregationPerson> lst = new ArrayList<DomCongregationPerson>();
        Set<String> cols = Util.createStringSet("congregation_id", "congregation_name", "person_id", "read_access", "write_access", "admin_access");
        String sql = " SELECT " + Util.setToStr(cols) + " FROM v_cong_person_access  WHERE person_id = ?  AND read_access = ?";
        ResultSet rs = null;
        PreparedStatement ps = Session.prepareStatement(sql);
        try {
            ps.setObject(1, (Object)PersonId, 4);
            ps.setBoolean(2, authorized);
            rs = ps.executeQuery();
            while (rs.next()) {
                lst.add(new DomCongregationPerson(rs, cols));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            ps.close();
        }
        return lst;
    }

    public static void setCongPersonAccess(List<DomCongregationPerson> list) throws SQLException {
        String sql = "{call set_cong_person(?, ?, ?)}";
        Integer permission = null;
        CallableStatement cs = Session.prepareCall(sql);
        for (DomCongregationPerson object : list) {
            cs.setObject(1, (Object)object.getCongregationId(), 4);
            cs.setObject(2, (Object)object.getPersonId(), 4);
            permission = null;
            if (object.isReadAccess()) {
                permission = 0;
            }
            if (object.isWriteAccess()) {
                permission = 1;
            }
            if (object.isAdminAccess()) {
                permission = 2;
            }
            cs.setObject(3, (Object)permission, 4);
            cs.execute();
        }
        cs.close();
        Session.connection().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DomShortEvent> listEvents(int personId) throws SQLException, ObjectNotFound {
        ArrayList<DomShortEvent> lst = new ArrayList<DomShortEvent>();
        String sql = "SELECT id, state, type, event_date, event_date_fuzzy_end FROM v_all_events WHERE person_id = ?";
        ResultSet rs = null;
        PreparedStatement ps = Session.prepareStatement(sql);
        try {
            ps.setObject(1, (Object)personId, 4);
            rs = ps.executeQuery();
            Set<String> cols = Util.createStringSet("id", "state", "type", "event_date", "event_date_fuzzy_end");
            while (rs.next()) {
                lst.add(new DomShortEvent(rs, cols));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            ps.close();
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DomPersonEventHistory> listEventHistory(int personId) throws SQLException, ObjectNotFound {
        ArrayList<DomPersonEventHistory> lst = new ArrayList<DomPersonEventHistory>();
        String sql = " SELECT event_type, time_type, event_date, target_name  FROM v_all_person_history WHERE person_id = ?";
        ResultSet rs = null;
        PreparedStatement ps = Session.prepareStatement(sql);
        try {
            ps.setObject(1, (Object)personId, 4);
            rs = ps.executeQuery();
            Set<String> cols = Util.createStringSet("event_type", "time_type", "event_date", "target_name");
            while (rs.next()) {
                lst.add(new DomPersonEventHistory(rs, cols));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            ps.close();
        }
        return lst;
    }

    public static List<DomPersonHistory> getPersonHistory(int personId) throws SQLException {
        String sql = " SELECT * FROM v_my_persons_history WHERE person_id = ? ";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)personId, 4);
        ArrayList<DomPersonHistory> result = new ArrayList<DomPersonHistory>();
        ResultSet rs = ps.executeQuery();
        Set<String> cols = Util.createStringSet("id", "person_id", "firstname", "lastname", "code", "sex", "birthplace", "birthdate", "birthdate_fuzzy_end", "deathdate", "deathdate_fuzzy_end", "membercard", "profession", "e-mail", "link", "phone", "nationality_id", "religion_id", "comment", "modified_comment", "modified_on", "modified_by", "deleted");
        while (rs.next()) {
            result.add(new DomPersonHistory(rs, cols));
        }
        rs.close();
        ps.close();
        return result;
    }

    public static List<DomPerson> fromResultSet(ResultSet rs, Set<String> fields) throws SQLException {
        ArrayList<DomPerson> result = new ArrayList<DomPerson>();
        while (rs.next()) {
            result.add(new DomPerson(rs, fields));
        }
        return result;
    }

    public static List<DomPersonAddress> getPersonAddresses(int personId) throws SQLException {
        String sql = "SELECT * FROM v_persons_address WHERE person_id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, personId);
        ArrayList<DomPersonAddress> result = new ArrayList<DomPersonAddress>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(new DomPersonAddress(rs));
        }
        rs.close();
        ps.close();
        return result;
    }

    public static void setPersonAddresses(int personId, List<DomPersonAddress> addresses) throws SQLException {
        List<DomPersonAddress> lst = MPerson.getPersonAddresses(personId);
        for (DomPersonAddress current : addresses) {
            boolean isNew = true;
            for (DomPersonAddress prev : lst) {
                if (!current.getAddress().equals(prev.getAddress())) continue;
                isNew = false;
                if (current.hasEqualValidityPeriod(prev)) break;
                MPersonAddress.instance().modify(current);
                break;
            }
            if (!isNew) continue;
            current.setPersonId(personId);
            MPersonAddress.instance().create(current);
        }
        for (DomPersonAddress prev : lst) {
            boolean removed = true;
            for (DomPersonAddress current : addresses) {
                if (!prev.getAddress().equals(current.getAddress())) continue;
                removed = false;
                break;
            }
            if (!removed) continue;
            MPersonAddress.instance().delete(prev.getId());
        }
    }

    public static List<DomAttribute> getAttributes(int personId) throws SQLException {
        ArrayList<DomAttribute> result = new ArrayList<DomAttribute>();
        String sql = "SELECT * FROM v_person_attributes WHERE person_id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, personId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(new DomAttribute(rs));
        }
        rs.close();
        ps.close();
        return result;
    }

    public static String getAge(DomPerson person) {
        int oldest;
        Date birth = person.getBirthDate();
        Date birthFuzzyEnd = person.getBirthDateFuzzyEnd() != null ? person.getBirthDateFuzzyEnd() : birth;
        Date death = person.getDeathDate();
        Date deathFuzzyEnd = person.getDeathDateFuzzyEnd() != null ? person.getDeathDateFuzzyEnd() : death;
        int youngest = Util.age(birthFuzzyEnd, death);
        if (youngest == (oldest = Util.age(birth, deathFuzzyEnd))) {
            return "" + youngest;
        }
        return youngest + "-" + oldest;
    }

    public static void setAttributes(int personId, List<DomAttribute> attributes) throws SQLException {
        List<DomAttribute> old = MPerson.getAttributes(personId);
        String sql = "{call add_person_attribute(?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, personId);
        cs.setInt(3, Session.congregation().getId());
        for (DomAttribute attr : attributes) {
            if (old.contains(attr)) continue;
            cs.setInt(2, attr.getId());
            cs.execute();
        }
        cs.close();
        sql = "{call remove_person_attribute(?, ?, ?)}";
        cs = Session.prepareCall(sql);
        cs.setInt(1, personId);
        cs.setInt(3, Session.congregation().getId());
        for (DomAttribute attr : old) {
            if (attributes.contains(attr)) continue;
            cs.setInt(2, attr.getId());
            cs.execute();
        }
        cs.close();
    }

    public static boolean isDirty(DomPerson person) throws SQLException {
        if (person == null) {
            return false;
        }
        DomPerson p = null;
        try {
            p = MPerson.instance().get(person.getId());
        }
        catch (ObjectNotFound e) {
            return false;
        }
        return person.getModified_on().before(p.getModified_on()) && !person.getModified_by().equals(p.getModified_by());
    }

    @Override
    public int create(DomPerson object) throws SQLException {
        String sql = "{? = call create_person(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        if (Session.current().getCongregation().getId() >= 0) {
            cs.setInt(2, Session.current().getCongregation().getId());
        } else {
            cs.setNull(2, 4);
        }
        cs.setString(3, object.getFirstName());
        cs.setString(4, object.getLastName());
        cs.setString(5, object.getMaidenName());
        cs.setString(6, object.getCode());
        if (object.getSex() != null) {
            cs.setInt(7, (int)object.getSex());
        } else {
            cs.setNull(7, 4);
        }
        cs.setString(8, object.getBirthPlace());
        cs.setDate(9, object.getBirthDate());
        cs.setDate(10, object.getBirthDateFuzzyEnd());
        cs.setDate(11, object.getDeathDate());
        cs.setDate(12, object.getDeathDateFuzzyEnd());
        cs.setString(13, object.getMembercard());
        if (object.getMaritalStatus() != null) {
            cs.setInt(14, (int)object.getMaritalStatus());
        } else {
            cs.setNull(14, 4);
        }
        cs.setString(15, object.getProfession());
        cs.setString(16, object.getEmail());
        cs.setString(17, object.getLink());
        cs.setString(18, object.getPhone());
        if (object.getNationalityId() != null) {
            cs.setInt(19, (int)object.getNationalityId());
        } else {
            cs.setNull(19, 4);
        }
        if (object.getReligionId() != null) {
            cs.setInt(20, (int)object.getReligionId());
        } else {
            cs.setNull(20, 4);
        }
        cs.setString(21, object.getComment());
        cs.setString(22, object.getBook());
        cs.setString(23, object.getPage());
        cs.setString(24, object.getModifiedComment());
        cs.execute();
        int result = cs.getInt(1);
        if (cs.getObject(1) != null) {
            object.setId(result);
        }
        cs.close();
        return result;
    }

    @Override
    public void modify(DomPerson object) throws SQLException {
        String sql = "{? = call modify_person(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, object.getId());
        cs.setInt(3, Session.current().getCongregation().getId());
        cs.setString(4, object.getFirstName());
        cs.setString(5, object.getLastName());
        cs.setString(6, object.getMaidenName());
        cs.setString(7, object.getCode());
        if (object.getSex() != null) {
            cs.setInt(8, (int)object.getSex());
        } else {
            cs.setNull(8, 4);
        }
        cs.setString(9, object.getBirthPlace());
        cs.setDate(10, object.getBirthDate());
        cs.setDate(11, object.getBirthDateFuzzyEnd());
        cs.setDate(12, object.getDeathDate());
        cs.setDate(13, object.getDeathDateFuzzyEnd());
        cs.setString(14, object.getMembercard());
        if (object.getMaritalStatus() != null) {
            cs.setInt(15, (int)object.getMaritalStatus());
        } else {
            cs.setNull(15, 4);
        }
        cs.setString(16, object.getProfession());
        cs.setString(17, object.getEmail());
        cs.setString(18, object.getLink());
        cs.setString(19, object.getPhone());
        if (object.getNationalityId() != null) {
            cs.setInt(20, (int)object.getNationalityId());
        } else {
            cs.setNull(20, 4);
        }
        if (object.getReligionId() != null) {
            cs.setInt(21, (int)object.getReligionId());
        } else {
            cs.setNull(21, 4);
        }
        cs.setString(22, object.getComment());
        cs.setString(23, object.getBook());
        cs.setString(24, object.getPage());
        DomAddress mostRecentAddress = MPerson.instance().getPersonsActiveAddress(object.getId());
        if (mostRecentAddress != null) {
            cs.setInt(25, mostRecentAddress.getId());
        } else {
            cs.setNull(25, 4);
        }
        cs.setString(26, object.getModifiedComment());
        cs.execute();
        cs.close();
    }

    @Override
    public DomPerson get(int objectID) throws SQLException, ObjectNotFound {
        return this.get(objectID, "SELECT * FROM v_my_persons WHERE id = ?", new String[0]);
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{call delete_person(?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, objectID);
        cs.setInt(2, Session.congregation().getId());
        cs.execute();
        cs.close();
    }

    public DomPerson getUserRelatedPerson(int relatedUserId) throws SQLException, ObjectNotFound {
        String sql = " SELECT p.*  FROM v_my_persons p JOIN v_my_users u ON (p.id = u.person_id)  WHERE u.id = ?";
        return this.get(relatedUserId, sql, new String[0]);
    }

    public DomPerson getUserRelatedPerson(String userName) throws SQLException, ObjectNotFound {
        String sql = " SELECT p.*  FROM v_my_persons p JOIN v_my_users u ON (p.id = u.person_id)  WHERE u.username = ?";
        DomPerson result = null;
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setString(1, userName);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = new DomPerson(rs);
        }
        rs.close();
        ps.close();
        if (result == null) {
            throw new ObjectNotFound(0);
        }
        return result;
    }

    public DomPerson getFromAll(int personId) throws SQLException, ObjectNotFound {
        return this.get(personId, "SELECT * FROM f_get_person(?)", "id", "firstname", "lastname", "birthdate", "code", "sex", "marital_status");
    }

    private DomPerson get(int id, String sql, String ... fields) throws SQLException, ObjectNotFound {
        DomPerson result = null;
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = fields.length == 0 ? new DomPerson(rs) : new DomPerson(rs, Util.createStringSet(fields));
        }
        rs.close();
        ps.close();
        if (result == null) {
            throw new ObjectNotFound(id);
        }
        return result;
    }

    public boolean exists(int objectId) throws SQLException {
        String sql = "{? = call check_person(?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 16);
        cs.setInt(2, objectId);
        cs.setBoolean(3, false);
        cs.execute();
        boolean result = cs.getBoolean(1);
        cs.close();
        return result;
    }

    public DomAddress getPersonsActiveAddress(int personId) throws SQLException {
        Set<String> cols = Util.createStringSet("id", "county", "country", "city", "street", "house", "postcode", "phone", "comment");
        String sql = " SELECT " + Util.setToStr(cols) + " FROM get_person_address(?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)personId, 4);
        ResultSet rs = ps.executeQuery();
        rs.next();
        DomAddress result = new DomAddress(rs, cols);
        if (result.getId() == 0) {
            result = null;
        }
        rs.close();
        ps.close();
        return result;
    }

    public Integer getCitizenshipId(int person_id) throws ObjectNotFound, SQLException {
        return this.getPersonMembership("{? = call get_person_citizenship(?)}", person_id);
    }

    public Integer setCitizenship(int person_id, Integer citizenship_id) throws SQLException {
        String sql = "{? = call set_person_citizenship(?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, person_id);
        if (citizenship_id != null) {
            cs.setInt(3, (int)citizenship_id);
        } else {
            cs.setNull(3, 4);
        }
        cs.execute();
        Integer result = cs.getObject(1) == null ? null : Integer.valueOf(cs.getInt(1));
        cs.close();
        return result;
    }

    public Integer getCongregation(int person_id) throws SQLException {
        return this.getPersonMembership("{? = call get_person_cong(?)}", person_id);
    }

    public Integer setCongregation(int person_id, Integer cong_id) throws SQLException {
        String sql = "{? = call set_person_cong(?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, person_id);
        if (cong_id == null) {
            cs.setNull(3, 4);
        } else {
            cs.setInt(3, (int)cong_id);
        }
        cs.execute();
        Integer result = cs.getObject(1) == null ? null : Integer.valueOf(cs.getInt(1));
        cs.close();
        return result;
    }

    public void alterPersonCongregations(int oldPersonId, int newPersonId) {
        String sql = "{call person_cong_change_person(?, ?)}";
        try {
            CallableStatement cs = Session.prepareCall(sql);
            cs.setInt(1, oldPersonId);
            cs.setInt(2, newPersonId);
            cs.execute();
            cs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Integer setMaritalStatus(int person_id, Integer marital_status) throws SQLException {
        String sql = "{? = call set_person_marital_status(?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, person_id);
        if (marital_status == null) {
            cs.setNull(3, 4);
        } else {
            cs.setInt(3, (int)marital_status);
        }
        cs.execute();
        Integer result = cs.getObject(1) == null ? null : Integer.valueOf(cs.getInt(1));
        cs.close();
        return result;
    }

    @Override
    public List<PersonResult> search(PersonExpression e) throws SQLException {
        List<PersonResult> list;
        this.preparePersonSearch(e);
        String sql = " SELECT distinct " + PersonResult.getFields() + "   FROM f_search_person_test(?, ?, ?, ?, ?, ?, ?, ?, ? ,? ,?, ?, ?, ?,         ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement ps = Session.prepareStatement(sql);){
            this.setPersonSearchParameters(ps, e);
            ResultSet rs = ps.executeQuery();
            list = PersonResult.fromResultSet(rs);
        }
        return list;
    }

    public List<PersonResult> findRelatives(int person_id, int level) throws SQLException {
        String sql = " SELECT DISTINCT " + PersonResult.getFields() + " FROM f_search_person_relatives(?, ?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)person_id, 4);
        ps.setObject(2, (Object)level, 4);
        ResultSet rs = ps.executeQuery();
        List<PersonResult> list = PersonResult.fromResultSet(rs);
        rs.close();
        ps.close();
        return list;
    }

    private Integer getPersonMembership(String sql, int person_id) throws SQLException {
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, person_id);
        cs.execute();
        Integer result = cs.getObject(1) == null ? null : Integer.valueOf(cs.getInt(1));
        cs.close();
        return result;
    }

    public DomPerson getFather(int personId) throws SQLException, ObjectNotFound {
        String sql = "{? = call get_father_id(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, personId);
        cs.execute();
        Integer result = cs.getObject(1) == null ? null : Integer.valueOf(cs.getInt(1));
        cs.close();
        if (result == null) {
            return null;
        }
        return this.getFromAll(result);
    }

    public DomPerson getMother(int personId) throws SQLException, ObjectNotFound {
        String sql = "{? = call get_mother_id(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, personId);
        cs.execute();
        Integer result = cs.getObject(1) == null ? null : Integer.valueOf(cs.getInt(1));
        cs.close();
        if (result == null) {
            return null;
        }
        return this.getFromAll(result);
    }

    public DomPerson getSpouse(int personId) throws SQLException, ObjectNotFound {
        String sql = "{? = call get_partner_id(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, personId);
        cs.execute();
        Integer result = cs.getObject(1) == null ? null : Integer.valueOf(cs.getInt(1));
        cs.close();
        if (result == null) {
            return null;
        }
        return this.getFromAll(result);
    }

    public List<DomPerson> getChildren(int personId) throws SQLException, ObjectNotFound {
        String sql = "SELECT * FROM get_children_persons(?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)personId, 4);
        ResultSet rs = ps.executeQuery();
        return MPerson.fromResultSet(rs, Util.createStringSet("id", "firstname", "lastname"));
    }

    public List<DomPersonWithRelationType> getOtherRelatives(int personId) throws SQLException {
        ArrayList<DomPersonWithRelationType> result = new ArrayList<DomPersonWithRelationType>();
        String sql = "SELECT * FROM v_other_relatives WHERE main_person_id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, personId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(new DomPersonWithRelationType(rs));
        }
        rs.close();
        ps.close();
        return result;
    }

    public List<String> getDuplicatePersonsCongregations(String firstName, String lastName, Date birthDate, int personId) throws SQLException {
        String sql = "select * FROM find_duplicate_persons_congregations(?, ?, ?, ?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setString(1, firstName);
        ps.setString(2, lastName);
        ps.setDate(3, birthDate);
        if (personId != -1) {
            ps.setInt(4, personId);
        } else {
            ps.setNull(4, 4);
        }
        ResultSet rs = ps.executeQuery();
        ArrayList<String> lst = new ArrayList<String>();
        while (rs.next()) {
            lst.add(rs.getString(1));
        }
        return lst;
    }

    public boolean personCodeExists(String code) throws SQLException {
        String sql = "select * from check_not_person_code(?, null, false)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setString(1, code);
        ResultSet rs = ps.executeQuery();
        rs.next();
        boolean result = rs.getBoolean(1);
        rs.close();
        return result;
    }

    private void setPersonSearchParameters(PreparedStatement ps, PersonExpression e) throws SQLException {
        ps.setString(1, Util.metaToDb((String)e.lastName.getValue()));
        ps.setString(2, Util.metaToDb((String)e.firstName.getValue()));
        ps.setString(3, (String)e.code.getValue());
        ps.setObject(4, e.congregation.getValue(), 4);
        if (!((Boolean)e.fullMemberLastYear.getValue()).booleanValue()) {
            ps.setObject(5, null, 16);
        } else {
            ps.setObject(5, e.fullMemberLastYear.getValue(), 16);
        }
        if (!((Boolean)e.fullMemberThisYear.getValue()).booleanValue()) {
            ps.setObject(6, null, 16);
        } else {
            ps.setObject(6, e.fullMemberThisYear.getValue(), 16);
        }
        ps.setObject(7, e.ageFrom.getValue(), 4);
        ps.setObject(8, e.ageTo.getValue(), 4);
        ps.setObject(9, e.dayOfBirthFrom.getValue(), 4);
        ps.setObject(10, e.monthOfBirthFrom.getValue(), 4);
        ps.setObject(11, e.dayOfBirthTo.getValue(), 4);
        ps.setObject(12, e.monthOfBirthTo.getValue(), 4);
        ps.setString(13, (String)e.city.getValue());
        ps.setString(14, (String)e.postcode.getValue());
        ps.setString(15, (String)e.comment.getValue());
        ps.setObject(16, e.sex.getValue(), 4);
        ps.setString(17, (String)e.positiveAttributes.getValue());
        ps.setString(18, (String)e.negativeAttributes.getValue());
        ps.setObject(19, e.group.getValue(), 4);
        ps.setObject(20, e.donationFrom.getValue(), 7);
        ps.setObject(21, e.donationTo.getValue(), 7);
        ps.setDate(22, (Date)e.donationDateFrom.getValue());
        ps.setDate(23, (Date)e.donationDateTo.getValue());
        ps.setObject(24, e.donationType.getValue());
        ps.setDate(25, (Date)e.deathDateFrom.getValue());
        ps.setDate(26, (Date)e.deathDateTo.getValue());
        ps.setObject(27, e.eventType.getValue(), 4);
        ps.setDate(28, (Date)e.eventDateFrom.getValue());
        ps.setDate(29, (Date)e.eventDateTo.getValue());
    }

    private void preparePersonSearch(PersonExpression e) throws SQLException {
        String sql = "SELECT prepare_person_search(?, ?, ?, ?, ?, ?, ?, ?, ? ,? ,?, ?, ?, ?,        ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement ps = Session.prepareStatement(sql);){
            this.setPersonSearchParameters(ps, e);
            ps.execute();
        }
    }
}

