/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomGroupName;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.GroupNameExpression;
import eelk.koguja.search.GroupNameResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MGroupName
extends Model<DomGroupName, GroupNameExpression, GroupNameResult> {
    private static MGroupName theInstance;

    private MGroupName() {
    }

    public static MGroupName instance() {
        if (theInstance == null) {
            theInstance = new MGroupName();
        }
        return theInstance;
    }

    public static List<DomGroupName> getCongUsableGroupNames(int congregationId) throws SQLException {
        String sql = "SELECT id, name FROM get_cong_usable_group_names(?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)congregationId, 4);
        ResultSet rs = ps.executeQuery();
        List<DomGroupName> lst = MGroupName.fromResultSet(rs, Util.createStringSet("id", "name"));
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomGroupName> listGroupNames() throws SQLException {
        String sql = "SELECT id, name FROM v_group_names";
        PreparedStatement ps = Session.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        List<DomGroupName> lst = MGroupName.fromResultSet(rs, Util.createStringSet("id", "name"));
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomGroupName> fromResultSet(ResultSet rs, Set<String> fields) throws SQLException {
        ArrayList<DomGroupName> result = new ArrayList<DomGroupName>();
        while (rs.next()) {
            result.add(new DomGroupName(rs, fields));
        }
        return result;
    }

    @Override
    public int create(DomGroupName object) throws SQLException {
        String sql = "{? = call create_group_name(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setString(2, object.getName());
        cs.execute();
        int id = cs.getInt(1);
        cs.close();
        return id;
    }

    @Override
    public DomGroupName get(int objectID) throws SQLException, ObjectNotFound {
        return null;
    }

    @Override
    public void modify(DomGroupName object) throws SQLException {
        String sql = "{? = call modify_group_name(?,?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)object.getId(), 4);
        cs.setString(3, object.getName());
        cs.execute();
        cs.close();
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{? = call delete_group_name(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)objectID, 4);
        cs.execute();
        cs.close();
    }

    @Override
    public List<GroupNameResult> search(GroupNameExpression expression) throws SQLException {
        return null;
    }
}

