/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomGroup;
import eelk.koguja.model.DomGroupMember;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.GroupExpression;
import eelk.koguja.search.GroupResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class MGroup
extends Model<DomGroup, GroupExpression, GroupResult> {
    private static MGroup theInstance;
    private HashMap<Integer, DomGroup> cashedGroups;

    protected MGroup() {
    }

    public static MGroup instance() {
        if (theInstance == null) {
            theInstance = new MGroup();
        }
        return theInstance;
    }

    public static List<DomGroup> listGroups(int congregationId) throws SQLException {
        String sql = "SELECT id, name, name_id, congregation_id FROM v_groups  WHERE congregation_id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)congregationId, 4);
        ResultSet rs = ps.executeQuery();
        List<DomGroup> lst = MGroup.fromResultSet(rs, Util.createStringSet("id", "name", "name_id", "congregation_id"));
        rs.close();
        ps.close();
        return lst;
    }

    public static void setMemberShip(List<DomGroupMember> mbs) throws SQLException {
        if (mbs == null) {
            return;
        }
        String sql = "{call set_person_group(?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        for (DomGroupMember d : mbs) {
            cs.setBoolean(1, d.isMember());
            cs.setInt(2, d.getPersonId());
            cs.setInt(3, d.getGroupId());
            cs.setObject(4, (Object)d.getRoleId(), 4);
            cs.execute();
        }
        cs.close();
        Session.connection().commit();
    }

    public static List<DomGroupMember> listMembership(int personId, Integer congId) throws SQLException {
        ArrayList<DomGroupMember> lst = new ArrayList<DomGroupMember>();
        Set<String> cols = Util.createStringSet("group_id", "group_name", "person_id", "is_member", "role_id");
        String sql = "SELECT " + Util.setToStr(cols) + " FROM v_person_active_groups  WHERE person_id = ?";
        if (congId != null) {
            sql = sql + " AND group_cong_id = ?";
        }
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, personId);
        if (congId != null) {
            ps.setInt(2, congId);
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            lst.add(new DomGroupMember(rs, cols));
        }
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomGroupMember> listGroupsRoles(int personId, Integer congId) throws SQLException {
        ArrayList<DomGroupMember> lst = new ArrayList<DomGroupMember>();
        Set<String> cols = Util.createStringSet("group_id", "group_name", "person_id", "is_member", "role_id", "role_name");
        String sql = "SELECT " + Util.setToStr(cols) + " FROM v_active_groups_roles  WHERE person_id = ?";
        if (congId != null) {
            sql = sql + " AND group_cong_id = ?";
        }
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, personId);
        if (congId != null) {
            ps.setInt(2, congId);
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            lst.add(new DomGroupMember(rs, cols));
        }
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomGroup> fromResultSet(ResultSet rs, Set<String> fields) throws SQLException {
        ArrayList<DomGroup> result = new ArrayList<DomGroup>();
        while (rs.next()) {
            result.add(new DomGroup(rs, fields));
        }
        return result;
    }

    @Override
    public int create(DomGroup object) throws SQLException {
        String sql = "{? = call create_group(?,?,?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setString(2, object.getName());
        cs.setObject(3, (Object)object.getNameId(), 4);
        cs.setObject(4, (Object)object.getCongregationId(), 4);
        cs.execute();
        int id = cs.getInt(1);
        cs.close();
        return id;
    }

    @Override
    public DomGroup get(int objectID) throws SQLException, ObjectNotFound {
        return null;
    }

    public DomGroup getCashed(int objectId) {
        return this.cashedGroups.get(objectId);
    }

    public void populateCashedCongs() throws SQLException {
        if (this.cashedGroups == null) {
            this.cashedGroups = new HashMap();
        }
        for (DomGroup group : MGroup.listGroups(Session.current().getCongregation().getId())) {
            this.cashedGroups.put(group.getId(), group);
        }
    }

    @Override
    public void modify(DomGroup object) throws SQLException {
        String sql = "{? = call modify_group(?,?,?,?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)object.getId(), 4);
        cs.setString(3, object.getName());
        cs.setObject(4, (Object)object.getNameId(), 4);
        cs.setObject(5, (Object)object.getCongregationId(), 4);
        cs.execute();
        cs.close();
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{? = call delete_group(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)objectID, 4);
        cs.execute();
        cs.close();
    }

    @Override
    public List<GroupResult> search(GroupExpression expression) throws SQLException {
        return null;
    }
}

