/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.MParticipant;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomFuneral;
import eelk.koguja.model.DomFuneralHistory;
import eelk.koguja.model.DomParticipant;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.FuneralExpression;
import eelk.koguja.search.FuneralResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MFuneral
extends Model<DomFuneral, FuneralExpression, FuneralResult> {
    private static MFuneral theInstance;

    private MFuneral() {
    }

    public static MFuneral instance() {
        if (theInstance == null) {
            theInstance = new MFuneral();
        }
        return theInstance;
    }

    public static DomFuneral getFuneralForPerson(Date eventDate, DomPerson person) throws SQLException {
        String sql = "SELECT * FROM v_my_funerals WHERE person_id IS NULL AND event_date = ? AND person_lastname = ? AND person_firstname = ? AND person_birthdate = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setDate(1, eventDate);
        ps.setString(2, person.getLastName());
        ps.setString(3, person.getFirstName());
        ps.setDate(4, person.getBirthDate());
        ResultSet rs = ps.executeQuery();
        DomFuneral result = rs.next() ? new DomFuneral(rs) : null;
        rs.close();
        ps.close();
        return result;
    }

    public static DomFuneral getFuneralForPerson(int personId) throws SQLException {
        String sql = "SELECT * FROM v_my_funerals WHERE person_id = ? ORDER BY event_date DESC";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, personId);
        ResultSet rs = ps.executeQuery();
        DomFuneral result = rs.next() ? new DomFuneral(rs) : null;
        rs.close();
        ps.close();
        return result;
    }

    public static boolean isDirty(DomFuneral funeral) throws SQLException {
        if (funeral == null) {
            return false;
        }
        DomFuneral f = null;
        try {
            f = MFuneral.instance().get(funeral.getId());
        }
        catch (ObjectNotFound e) {
            return false;
        }
        return funeral.getModified_on().before(f.getModified_on());
    }

    public static String getNextDocNr(Integer congregation) throws SQLException {
        String sql = "{? = call get_next_funeral_doc_nr(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 12);
        cs.setObject(2, (Object)congregation, 4);
        cs.execute();
        String result = cs.getString(1);
        cs.close();
        return result;
    }

    @Override
    public int create(DomFuneral funeral) throws SQLException {
        String sql = "{? = call create_funeral(?, (select get_next_funeral_doc_nr(?)),?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        try (CallableStatement cs = Session.prepareCall(sql);){
            cs.registerOutParameter(1, 4);
            cs.setInt(2, Session.current().getCongregation().getId());
            if (funeral.getCongregationId() == null) {
                cs.setNull(3, 4);
                cs.setNull(4, 4);
            } else {
                cs.setInt(3, (int)funeral.getCongregationId());
                cs.setInt(4, (int)funeral.getCongregationId());
            }
            cs.setString(5, funeral.getCongregationName());
            cs.setDate(6, funeral.getApplicationDate());
            if (funeral.getState() == null) {
                cs.setNull(7, 4);
            } else {
                cs.setInt(7, (int)funeral.getState());
            }
            cs.setDate(8, funeral.getEventDate());
            cs.setDate(9, funeral.getEventFuzzyDate());
            cs.setTime(10, funeral.getEventStart());
            cs.setTime(11, funeral.getEventEnd());
            cs.setString(12, funeral.getScripturalPassage());
            cs.setString(13, funeral.getLegitimation());
            if (funeral.getOffciantId() == null) {
                cs.setNull(14, 4);
            } else {
                cs.setInt(14, (int)funeral.getOffciantId());
            }
            if (funeral.getLocationId() == null) {
                cs.setNull(15, 4);
            } else {
                cs.setInt(15, (int)funeral.getLocationId());
            }
            cs.setString(16, funeral.getComment());
            if (funeral.getPersonId() == null) {
                cs.setNull(17, 4);
            } else {
                cs.setInt(17, (int)funeral.getPersonId());
            }
            cs.setDate(18, funeral.getDeathDate());
            cs.setString(19, funeral.getDeathPlace());
            cs.setString(20, funeral.getDeathCertNo());
            cs.setString(21, funeral.getDeathReason());
            if (funeral.getBurialPermission() == null) {
                cs.setNull(22, 16);
            } else {
                cs.setBoolean(22, (boolean)funeral.getBurialPermission());
            }
            cs.setDate(23, funeral.getCremationTime());
            cs.setDate(24, funeral.getBurialTime());
            cs.setString(25, funeral.getGraveLocation());
            if (funeral.isReburial() == null) {
                cs.setNull(26, 16);
            } else {
                cs.setBoolean(26, (boolean)funeral.isReburial());
            }
            cs.setString(27, funeral.getBook());
            cs.setString(28, funeral.getPage());
            cs.execute();
            int result = cs.getInt(1);
            if (cs.getObject(1) != null) {
                funeral.setId(result);
            }
            int n = result;
            return n;
        }
    }

    @Override
    public void modify(DomFuneral funeral) throws SQLException {
        String sql = "{? = call modify_funeral(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, funeral.getId());
        cs.setInt(3, Session.current().getCongregation().getId());
        if (funeral.getCongregationId() == null) {
            cs.setNull(4, 4);
        } else {
            cs.setInt(4, (int)funeral.getCongregationId());
        }
        cs.setString(5, funeral.getCongregationName());
        cs.setDate(6, funeral.getApplicationDate());
        if (funeral.getState() == null) {
            cs.setNull(7, 4);
        } else {
            cs.setInt(7, (int)funeral.getState());
        }
        cs.setDate(8, funeral.getEventDate());
        cs.setDate(9, funeral.getEventFuzzyDate());
        cs.setTime(10, funeral.getEventStart());
        cs.setTime(11, funeral.getEventEnd());
        cs.setString(12, funeral.getScripturalPassage());
        cs.setString(13, funeral.getLegitimation());
        if (funeral.getOffciantId() == null) {
            cs.setNull(14, 4);
        } else {
            cs.setInt(14, (int)funeral.getOffciantId());
        }
        if (funeral.getLocationId() == null) {
            cs.setNull(15, 4);
        } else {
            cs.setInt(15, (int)funeral.getLocationId());
        }
        cs.setString(16, funeral.getComment());
        if (funeral.getPersonId() == null) {
            cs.setNull(17, 4);
        } else {
            cs.setInt(17, (int)funeral.getPersonId());
        }
        cs.setDate(18, funeral.getDeathDate());
        cs.setString(19, funeral.getDeathPlace());
        cs.setString(20, funeral.getDeathCertNo());
        cs.setString(21, funeral.getDeathReason());
        if (funeral.getBurialPermission() == null) {
            cs.setNull(22, 16);
        } else {
            cs.setBoolean(22, (boolean)funeral.getBurialPermission());
        }
        cs.setDate(23, funeral.getCremationTime());
        cs.setDate(24, funeral.getBurialTime());
        cs.setString(25, funeral.getGraveLocation());
        if (funeral.isReburial() == null) {
            cs.setNull(26, 16);
        } else {
            cs.setBoolean(26, (boolean)funeral.isReburial());
        }
        cs.setString(27, funeral.getBook());
        cs.setString(28, funeral.getPage());
        cs.setString(29, funeral.getModifiedComment());
        cs.execute();
        cs.close();
    }

    @Override
    public DomFuneral get(int objectID) throws SQLException, ObjectNotFound {
        DomFuneral result = null;
        String sql = "SELECT * FROM v_my_funerals WHERE id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, objectID);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = new DomFuneral(rs);
        }
        rs.close();
        ps.close();
        if (result == null) {
            throw new ObjectNotFound(objectID);
        }
        return result;
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{call delete_funeral(?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, objectID);
        cs.setInt(2, Session.congregation().getId());
        cs.execute();
        cs.close();
    }

    @Override
    public List<FuneralResult> search(FuneralExpression e) throws SQLException {
        String sql = "SELECT " + FuneralResult.getFields() + "  FROM f_search_funeral(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setString(1, Util.c((String)e.documentNumberFrom.getValue()));
        ps.setString(2, Util.c((String)e.documentNumberTo.getValue()));
        ps.setObject(3, e.congregation.getValue(), 4);
        ps.setObject(4, e.state.getValue(), 4);
        ps.setObject(5, e.stateExcept.getValue(), 4);
        ps.setDate(6, (Date)e.eventDateStart.getValue());
        ps.setDate(7, (Date)e.eventDateEnd.getValue());
        ps.setDate(8, (Date)e.appDateStart.getValue());
        ps.setDate(9, (Date)e.appDateEnd.getValue());
        ps.setTime(10, (Time)e.eventTimeStart.getValue());
        ps.setTime(11, (Time)e.eventTimeEnd.getValue());
        ps.setObject(12, e.place.getValue(), 4);
        ps.setString(13, Util.metaToDb((String)e.lastName.getValue()));
        ps.setString(14, Util.metaToDb((String)e.firstName.getValue()));
        ps.setDate(15, (Date)e.birthDate.getValue());
        ps.setObject(16, e.ageFrom.getValue(), 4);
        ps.setObject(17, e.ageTo.getValue(), 4);
        ps.setObject(18, e.sex.getValue(), 4);
        ps.setString(19, Util.metaToDb(Util.c((String)e.participantFirstName.getValue())));
        ps.setString(20, Util.metaToDb(Util.c((String)e.participantLastName.getValue())));
        ResultSet rs = ps.executeQuery();
        List<FuneralResult> list = FuneralResult.fromResultSet(rs);
        rs.close();
        ps.close();
        return list;
    }

    public List<DomParticipant> getParticipants(Integer funeralId) throws SQLException {
        String sql = "SELECT * FROM v_funerals_participants WHERE funeral_id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, funeralId);
        ResultSet rs = ps.executeQuery();
        List<DomParticipant> result = MParticipant.fromResultSet(rs, Util.createStringSet("id", "funeral_id", "person_id", "role_id", "person_firstname", "person_lastname", "person_deathdate"));
        rs.close();
        ps.close();
        return result;
    }

    public void setParticipants(Integer funeralId, List<DomParticipant> lstParts) throws SQLException {
        List<DomParticipant> lst = this.getParticipants(funeralId);
        String insSql = "{? = call create_funeral_participant(?, ?, ?, ?)}";
        String modSql = "{call modify_funeral_participant(?, ?, ?, ?, ?)}";
        String delSql = "{call delete_funeral_participant(?, ?)}";
        for (DomParticipant initPart : lst) {
            if (lstParts.contains(initPart)) continue;
            MParticipant.instance().deleteParticipant(initPart, "{call delete_funeral_participant(?, ?)}", funeralId);
        }
        block1: for (DomParticipant part : lstParts) {
            if (!lst.contains(part)) {
                MParticipant.instance().createParticipant(funeralId, part, "{? = call create_funeral_participant(?, ?, ?, ?)}");
                continue;
            }
            for (DomParticipant initPart : lst) {
                if (initPart.hasEqualFields(part)) break;
                if (!initPart.equals(part)) continue;
                MParticipant.instance().modifyParticipant(funeralId, part, "{call modify_funeral_participant(?, ?, ?, ?, ?)}");
                continue block1;
            }
        }
    }

    public List<DomFuneralHistory> getFuneralHistory(int funeralId) throws SQLException {
        String sql = " SELECT * FROM v_my_funerals_history WHERE funeral_id = ? ";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)funeralId, 4);
        ArrayList<DomFuneralHistory> result = new ArrayList<DomFuneralHistory>();
        ResultSet rs = ps.executeQuery();
        Set<String> cols = Util.createStringSet("id", "funeral_id", "congregation_id", "congregation_name", "application_date", "state", "event_date", "event_date_fuzzy_end", "event_start", "event_end", "donation_id", "scriptural_passage", "legitimation", "officiant_id", "location_id", "comment", "person_id", "person_firstname", "person_lastname", "person_birthdate", "person_code", "death_time", "death_place", "death_cert_no", "death_reason", "burial_permission", "cremation_time", "burial_time", "grave_location", "is_reburial", "modified_comment", "modified_on", "odified_by", "deleted");
        while (rs.next()) {
            result.add(new DomFuneralHistory(rs, cols));
        }
        rs.close();
        ps.close();
        return result;
    }
}

