/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomEventLocation;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.EventLocationExpression;
import eelk.koguja.search.EventLocationResult;
import eelk.koguja.util.Util;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class MEventLocation
extends Model<DomEventLocation, EventLocationExpression, EventLocationResult> {
    private static MEventLocation theInstance;
    private HashMap<Integer, DomEventLocation> cashedLocations;

    private MEventLocation() {
    }

    public static MEventLocation instance() {
        if (theInstance == null) {
            theInstance = new MEventLocation();
        }
        return theInstance;
    }

    public static List<DomEventLocation> listEventLocations(Integer congregationId) throws SQLException {
        String sql = "SELECT id, name, congregation_id FROM v_locations";
        if (congregationId != null) {
            sql = sql + " WHERE congregation_id = ?";
        }
        PreparedStatement ps = Session.prepareStatement(sql);
        if (congregationId != null) {
            ps.setObject(1, (Object)congregationId, 4);
        }
        ResultSet rs = ps.executeQuery();
        List<DomEventLocation> lst = MEventLocation.fromResultSet(rs, Util.createStringSet("id", "name", "congregation_id"));
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomEventLocation> fromResultSet(ResultSet rs, Set<String> fields) throws SQLException {
        ArrayList<DomEventLocation> result = new ArrayList<DomEventLocation>();
        while (rs.next()) {
            result.add(new DomEventLocation(rs, fields));
        }
        return result;
    }

    public DomEventLocation getCashed(int objectId) {
        return this.cashedLocations.get(objectId);
    }

    public void populateCashedLocations(Integer congregationId) throws SQLException {
        if (this.cashedLocations == null) {
            this.cashedLocations = new HashMap();
        }
        for (DomEventLocation loc : MEventLocation.listEventLocations(congregationId)) {
            this.cashedLocations.put(loc.getId(), loc);
        }
    }

    @Override
    public int create(DomEventLocation object) throws SQLException {
        return 0;
    }

    @Override
    public DomEventLocation get(int objectID) throws SQLException, ObjectNotFound {
        return null;
    }

    @Override
    public void modify(DomEventLocation object) throws SQLException {
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
    }

    @Override
    public List<EventLocationResult> search(EventLocationExpression expression) throws SQLException {
        return null;
    }
}

