/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomDonationUse;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.DonationUseExpression;
import eelk.koguja.search.DonationUseResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MDonationUse
extends Model<DomDonationUse, DonationUseExpression, DonationUseResult> {
    private static MDonationUse theInstance;

    private MDonationUse() {
    }

    public static MDonationUse instance() {
        if (theInstance == null) {
            theInstance = new MDonationUse();
        }
        return theInstance;
    }

    public static List<DomDonationUse> listDonationUses(int congregationId) throws SQLException {
        String sql = "SELECT id, name, congregation_id FROM v_donation_intended_uses WHERE congregation_id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)congregationId, 4);
        ResultSet rs = ps.executeQuery();
        List<DomDonationUse> lst = MDonationUse.fromResultSet(rs, Util.createStringSet("id", "name", "congregation_id"));
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomDonationUse> fromResultSet(ResultSet rs, Set<String> fields) throws SQLException {
        ArrayList<DomDonationUse> result = new ArrayList<DomDonationUse>();
        while (rs.next()) {
            result.add(new DomDonationUse(rs, fields));
        }
        return result;
    }

    @Override
    public int create(DomDonationUse object) throws SQLException {
        String sql = "{? = call create_donation_intended_use(?,?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setString(2, object.getName());
        cs.setObject(3, (Object)object.getCongregationId(), 4);
        cs.execute();
        int id = cs.getInt(1);
        cs.close();
        return id;
    }

    @Override
    public DomDonationUse get(int objectID) throws SQLException, ObjectNotFound {
        return null;
    }

    @Override
    public void modify(DomDonationUse object) throws SQLException {
        String sql = "{? = call modify_donation_intended_use(?,?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)object.getId(), 4);
        cs.setString(3, object.getName());
        cs.execute();
        cs.close();
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{? = call delete_donation_intended_use(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)objectID, 4);
        cs.execute();
        cs.close();
    }

    @Override
    public List<DonationUseResult> search(DonationUseExpression expression) throws SQLException {
        return null;
    }
}

