/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomDonationType;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.DonationTypeExpression;
import eelk.koguja.search.DonationTypeResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MDonationType
extends Model<DomDonationType, DonationTypeExpression, DonationTypeResult> {
    private static MDonationType theInstance;

    private MDonationType() {
    }

    public static MDonationType instance() {
        if (theInstance == null) {
            theInstance = new MDonationType();
        }
        return theInstance;
    }

    public static List<DomDonationType> listDonationTypes(boolean orderByMbs) throws SQLException {
        String sql = orderByMbs ? "SELECT id, name, is_mbs_donation FROM v_donation_types ORDER BY is_mbs_donation DESC, name ASC" : "SELECT id, name, is_mbs_donation FROM v_donation_types ORDER BY name ASC";
        PreparedStatement ps = Session.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        List<DomDonationType> lst = MDonationType.fromResultSet(rs, Util.createStringSet("id", "name", "is_mbs_donation"));
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomDonationType> fromResultSet(ResultSet rs, Set<String> fields) throws SQLException {
        ArrayList<DomDonationType> result = new ArrayList<DomDonationType>();
        while (rs.next()) {
            result.add(new DomDonationType(rs, fields));
        }
        return result;
    }

    @Override
    public int create(DomDonationType object) throws SQLException {
        String sql = "{? = call create_donation_type(?,?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setString(2, object.getName());
        cs.setBoolean(3, (boolean)object.getIsMbsDonation());
        cs.execute();
        int id = cs.getInt(1);
        cs.close();
        return id;
    }

    @Override
    public DomDonationType get(int objectID) throws SQLException, ObjectNotFound {
        return null;
    }

    @Override
    public void modify(DomDonationType object) throws SQLException {
        String sql = "{? = call modify_donation_type(?,?,?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)object.getId(), 4);
        cs.setString(3, object.getName());
        cs.setBoolean(4, (boolean)object.getIsMbsDonation());
        cs.execute();
        cs.close();
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{? = call delete_donation_type(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)objectID, 4);
        cs.execute();
        cs.close();
    }

    @Override
    public List<DonationTypeResult> search(DonationTypeExpression expression) throws SQLException {
        return null;
    }
}

