/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomDonation;
import eelk.koguja.model.DomDonationHistory;
import eelk.koguja.model.DomDonationWithTypeName;
import eelk.koguja.model.DomDonationsSum;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.DonationExpression;
import eelk.koguja.search.DonationHistoryResult;
import eelk.koguja.search.DonationResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;

public class MDonation
extends Model<DomDonation, DonationExpression, DonationResult> {
    private static MDonation theInstance;

    private MDonation() {
    }

    public static MDonation instance() {
        if (theInstance == null) {
            theInstance = new MDonation();
        }
        return theInstance;
    }

    public static List<DomDonationWithTypeName> listMyDonations(Integer personId) throws SQLException {
        ArrayList<DomDonationWithTypeName> lst = new ArrayList<DomDonationWithTypeName>();
        String sql = "SELECT * FROM v_donations_and_types";
        if (personId != null) {
            sql = sql + " WHERE person_id = ?";
        }
        sql = sql + " ORDER BY donation_date DESC";
        PreparedStatement ps = Session.prepareStatement(sql);
        if (personId != null) {
            ps.setObject(1, (Object)personId, 4);
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            lst.add(new DomDonationWithTypeName(rs));
        }
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomDonationsSum> listMyDonationsSumByYear(Integer personId) throws SQLException {
        List<DomDonationWithTypeName> lst = MDonation.listMyDonations(personId);
        ArrayList<DomDonationsSum> sumList = new ArrayList<DomDonationsSum>();
        DomDonationsSum sumYear = null;
        for (DomDonationWithTypeName donation : lst) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(donation.getDonationDate());
            if (sumYear != null && cal.get(1) == sumYear.getYear()) {
                sumYear.add(donation);
            } else {
                if (sumYear != null && sumYear.isSum()) {
                    sumList.add(sumList.size() - sumYear.getSumOf(), sumYear);
                }
                sumYear = new DomDonationsSum(donation);
            }
            sumList.add(new DomDonationsSum(donation));
        }
        if (sumYear != null && sumYear.isSum()) {
            sumList.add(sumList.size() - sumYear.getSumOf(), sumYear);
        }
        return sumList;
    }

    public static List<DomDonation> listINF4ReportDonations(int congId) throws SQLException {
        ArrayList<DomDonation> result = new ArrayList<DomDonation>();
        String sql = "SELECT   person_firstname,          person_lastname,          person_code,          amount,          congregation_id,          donation_from,          is_tax_returned     FROM v_inf4_donations    WHERE congregation_id = ? ORDER BY person_lastname ASC,          person_firstname ASC";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, congId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(new DomDonation(rs, Util.createStringSet("person_firstname", "person_lastname", "person_code", "amount", "congregation_id", "donation_from", "is_tax_returned")));
        }
        rs.close();
        return result;
    }

    public static String getLastYear() throws SQLException {
        String result = "";
        String sql = "SELECT date_part('year',current_date)-1 as current_year";
        PreparedStatement ps = Session.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result = rs.getString("current_year");
        }
        rs.close();
        return result;
    }

    public static boolean isDirty(DomDonation donation) throws SQLException {
        if (donation == null) {
            return false;
        }
        DomDonation d = null;
        try {
            d = MDonation.instance().get(donation.getId());
        }
        catch (ObjectNotFound e) {
            return false;
        }
        return donation.getModified_on().before(d.getModified_on());
    }

    public static String getNextDocNr(Integer congregation) throws SQLException {
        String sql = "{? = call get_next_donation_doc_nr(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 12);
        cs.setObject(2, (Object)congregation, 4);
        cs.execute();
        String result = cs.getString(1);
        cs.close();
        return result;
    }

    public static List<DomDonationHistory> getDonationHistory(int donationId) throws SQLException {
        String sql = " SELECT * FROM v_my_donations_history WHERE donation_id = ? ";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)donationId, 4);
        ArrayList<DomDonationHistory> result = new ArrayList<DomDonationHistory>();
        ResultSet rs = ps.executeQuery();
        Set<String> cols = Util.createStringSet("id", "donation_id", "doc_nr", "type_id", "is_mbs_donation", "intended_use_id", "donation_from", "person_id", "person_firstname", "person_lastname", "person_birthdate", "person_code", "group_id", "group_name", "congregation_id", "donation_date", "donation_object", "amount", "is_approx_amount", "is_tax_returned", "payment_method", "book", "page", "comment", "modified_comment", "modified_on", "modified_by");
        while (rs.next()) {
            result.add(new DomDonationHistory(rs, cols));
        }
        rs.close();
        ps.close();
        return result;
    }

    @Override
    public int create(DomDonation donation) throws SQLException {
        String sql = "{? = call create_donation(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        if (donation.getCongregationId() == null) {
            cs.setNull(2, 4);
        } else {
            cs.setInt(2, (int)donation.getCongregationId());
        }
        cs.setString(3, donation.getDocNr());
        if (donation.getTypeId() == null) {
            cs.setNull(4, 4);
        } else {
            cs.setInt(4, (int)donation.getTypeId());
        }
        if (donation.getIntendedUseId() == null) {
            cs.setNull(5, 4);
        } else {
            cs.setInt(5, (int)donation.getIntendedUseId());
        }
        if (donation.getDonationFrom() == null) {
            cs.setNull(6, 4);
        } else {
            cs.setInt(6, (int)donation.getDonationFrom());
        }
        if (donation.getPersonId() == null) {
            cs.setNull(7, 4);
        } else {
            cs.setInt(7, (int)donation.getPersonId());
        }
        if (donation.getGroupId() == null) {
            cs.setNull(8, 4);
        } else {
            cs.setInt(8, (int)donation.getGroupId());
        }
        cs.setString(9, donation.getGroupName());
        cs.setDate(10, donation.getDonationDate());
        cs.setString(11, donation.getDonationObject());
        if (donation.getAmount() == null) {
            cs.setNull(12, 7);
        } else {
            cs.setBigDecimal(12, donation.getAmount());
        }
        if (donation.isApproxAmount() == null) {
            cs.setNull(13, 16);
        } else {
            cs.setBoolean(13, (boolean)donation.isApproxAmount());
        }
        if (donation.isTaxReturned() == null) {
            cs.setNull(14, 16);
        } else {
            cs.setBoolean(14, (boolean)donation.isTaxReturned());
        }
        if (donation.getPaymentMethod() == null) {
            cs.setNull(15, 4);
        } else {
            cs.setInt(15, (int)donation.getPaymentMethod());
        }
        cs.setString(16, donation.getComment());
        cs.setString(17, donation.getBook());
        cs.setString(18, donation.getPage());
        cs.execute();
        int result = cs.getInt(1);
        if (cs.getObject(1) != null) {
            donation.setId(result);
        }
        cs.close();
        return result;
    }

    @Override
    public void modify(DomDonation donation) throws SQLException {
        String sql = "{? = call modify_donation(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, donation.getId());
        if (donation.getCongregationId() == null) {
            cs.setNull(3, 4);
        } else {
            cs.setInt(3, (int)donation.getCongregationId());
        }
        if (donation.getTypeId() == null) {
            cs.setNull(4, 4);
        } else {
            cs.setInt(4, (int)donation.getTypeId());
        }
        if (donation.getIntendedUseId() == null) {
            cs.setNull(5, 4);
        } else {
            cs.setInt(5, (int)donation.getIntendedUseId());
        }
        if (donation.getDonationFrom() == null) {
            cs.setNull(6, 4);
        } else {
            cs.setInt(6, (int)donation.getDonationFrom());
        }
        if (donation.getPersonId() == null) {
            cs.setNull(7, 4);
        } else {
            cs.setInt(7, (int)donation.getPersonId());
        }
        if (donation.getGroupId() == null) {
            cs.setNull(8, 4);
        } else {
            cs.setInt(8, (int)donation.getGroupId());
        }
        cs.setString(9, donation.getGroupName());
        cs.setDate(10, donation.getDonationDate());
        cs.setString(11, donation.getDonationObject());
        if (donation.getAmount() == null) {
            cs.setNull(12, 7);
        } else {
            cs.setBigDecimal(12, donation.getAmount());
        }
        if (donation.isApproxAmount() == null) {
            cs.setNull(13, 16);
        } else {
            cs.setBoolean(13, (boolean)donation.isApproxAmount());
        }
        if (donation.isTaxReturned() == null) {
            cs.setNull(14, 16);
        } else {
            cs.setBoolean(14, (boolean)donation.isTaxReturned());
        }
        if (donation.getPaymentMethod() == null) {
            cs.setNull(15, 4);
        } else {
            cs.setInt(15, (int)donation.getPaymentMethod());
        }
        cs.setString(16, donation.getComment());
        cs.setString(17, donation.getBook());
        cs.setString(18, donation.getPage());
        cs.setString(19, donation.getModifiedComment());
        cs.execute();
        cs.close();
    }

    @Override
    public DomDonation get(int objectID) throws SQLException, ObjectNotFound {
        DomDonation result = null;
        String sql = "SELECT * FROM v_my_donations WHERE id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, objectID);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = new DomDonation(rs);
        }
        rs.close();
        ps.close();
        if (result == null) {
            throw new ObjectNotFound(objectID);
        }
        return result;
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{call delete_donation(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, objectID);
        cs.execute();
        cs.close();
    }

    @Override
    public List<DonationResult> search(DonationExpression e) throws SQLException {
        if (e.searchHistory.getValue() != null && ((Boolean)e.searchHistory.getValue()).booleanValue()) {
            return this.searchHistory(e);
        }
        String sql = " SELECT " + DonationResult.getFields() + " FROM f_search_donation(?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, e.donationFrom.getValue(), 4);
        ps.setString(2, Util.metaToDb((String)e.lastName.getValue()));
        ps.setString(3, Util.metaToDb((String)e.firstName.getValue()));
        ps.setObject(4, e.group.getValue(), 4);
        ps.setDate(5, (Date)e.dateFrom.getValue());
        ps.setDate(6, (Date)e.dateTo.getValue());
        ps.setObject(7, e.congregation.getValue(), 4);
        ps.setObject(8, e.amountFrom.getValue(), 7);
        ps.setObject(9, e.amountTo.getValue(), 7);
        ResultSet rs = ps.executeQuery();
        List<DonationResult> list = DonationResult.fromResultSet(rs);
        rs.close();
        ps.close();
        return list;
    }

    public List<DonationResult> searchHistory(DonationExpression e) throws SQLException {
        String sql = " SELECT " + DonationResult.getFields() + " FROM f_search_donation_history(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, e.donationFrom.getValue(), 4);
        ps.setString(2, Util.metaToDb((String)e.lastName.getValue()));
        ps.setString(3, Util.metaToDb((String)e.firstName.getValue()));
        ps.setObject(4, e.group.getValue(), 4);
        ps.setDate(5, (Date)e.dateFrom.getValue());
        ps.setDate(6, (Date)e.dateTo.getValue());
        ps.setObject(7, e.congregation.getValue(), 4);
        ps.setObject(8, e.amountFrom.getValue(), 7);
        ps.setObject(9, e.amountTo.getValue(), 7);
        ps.setDate(10, (Date)e.historyFrom.getValue());
        ps.setDate(11, (Date)e.historyTo.getValue());
        ResultSet rs = ps.executeQuery();
        List<DonationResult> list = DonationHistoryResult.historyFromResultSet(rs);
        rs.close();
        ps.close();
        return list;
    }
}

