/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomDeanery;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.DeaneryExpression;
import eelk.koguja.search.DeaneryResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MDeanery
extends Model<DomDeanery, DeaneryExpression, DeaneryResult> {
    private static MDeanery theInstance;

    private MDeanery() {
    }

    public static MDeanery instance() {
        if (theInstance == null) {
            theInstance = new MDeanery();
        }
        return theInstance;
    }

    public static List<DomDeanery> listDeaneries() throws SQLException {
        String sql = "SELECT id, name FROM v_deaneries";
        PreparedStatement ps = Session.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        List<DomDeanery> lst = MDeanery.fromResultSet(rs, Util.createStringSet("id", "name"));
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomDeanery> fromResultSet(ResultSet rs, Set<String> fields) throws SQLException {
        ArrayList<DomDeanery> result = new ArrayList<DomDeanery>();
        while (rs.next()) {
            result.add(new DomDeanery(rs, fields));
        }
        return result;
    }

    @Override
    public int create(DomDeanery object) throws SQLException {
        String sql = "{? = call create_deanery(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setString(2, object.getName());
        cs.execute();
        int id = cs.getInt(1);
        cs.close();
        return id;
    }

    @Override
    public void modify(DomDeanery object) throws SQLException {
        String sql = "{? = call modify_deanery(?,?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)object.getId(), 4);
        cs.setString(3, object.getName());
        cs.execute();
        cs.close();
    }

    @Override
    public DomDeanery get(int objectID) throws SQLException, ObjectNotFound {
        return null;
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{? = call delete_deanery(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)objectID, 4);
        cs.execute();
        cs.close();
    }

    @Override
    public List<DeaneryResult> search(DeaneryExpression expression) throws SQLException {
        return null;
    }
}

