/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.CongregationExpression;
import eelk.koguja.search.CongregationResult;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class MCongregation
extends Model<DomCongregation, CongregationExpression, CongregationResult> {
    private static MCongregation theInstance;
    private HashMap<Integer, DomCongregation> cashedCongregations;

    private MCongregation() {
    }

    public static MCongregation instance() {
        if (theInstance == null) {
            theInstance = new MCongregation();
        }
        return theInstance;
    }

    public static List<DomCongregation> listMyCongregations() throws SQLException {
        String sql = "SELECT id, name, location, email, write_access, admin_access, deanery_id, address_id, 0 as automailer_enabled FROM v_my_congregations";
        PreparedStatement ps = Session.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        List<DomCongregation> lst = MCongregation.fromResultSet(rs, Util.createStringSet("id", "name", "location", "email", "write_access", "admin_access", "deanery_id", "address_id", "automailer_enabled"));
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomCongregation> listCongregations() throws SQLException {
        return MCongregation.listCongregations(null);
    }

    public static List<DomCongregation> listCongregations(Integer deaneryId) throws SQLException {
        return MCongregation.listCongregations(deaneryId, null);
    }

    public static List<DomCongregation> listCongregations(Integer deaneryId, Integer orderByCongId) throws SQLException {
        String sql = "SELECT id, name, location, email, deanery_id, address_id, 0 as automailer_enabled FROM v_congregations";
        if (deaneryId != null) {
            sql = sql + " WHERE deanery_id = ?";
        }
        sql = orderByCongId != null ? sql + " ORDER BY id <> ?, name asc" : sql + " ORDER BY name asc";
        PreparedStatement ps = Session.prepareStatement(sql);
        if (deaneryId != null) {
            ps.setObject(1, (Object)deaneryId, 4);
        }
        if (orderByCongId != null) {
            ps.setObject(deaneryId == null ? 1 : 2, (Object)orderByCongId, 4);
        }
        ResultSet rs = ps.executeQuery();
        List<DomCongregation> lst = MCongregation.fromResultSet(rs, Util.createStringSet("id", "name", "location", "email", "deanery_id", "address_id", "automailer_enabled"));
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomCongregation> listMyCongregations(IDbUtil.Permission permission) throws SQLException {
        String sql = "SELECT id, name, location, email, deanery_id, 0 as automailer_enabled FROM v_my_congregations ";
        if (permission == IDbUtil.Permission.Write) {
            sql = sql + " WHERE write_access = TRUE ";
        } else if (permission == IDbUtil.Permission.Admin) {
            sql = sql + " WHERE admin_access = TRUE ";
        }
        PreparedStatement ps = Session.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        List<DomCongregation> lst = MCongregation.fromResultSet(rs, Util.createStringSet("id", "name", "location", "email", "deanery_id", "automailer_enabled"));
        rs.close();
        ps.close();
        return lst;
    }

    private static List<DomCongregation> fromResultSet(ResultSet rs, Set<String> fields) throws SQLException {
        ArrayList<DomCongregation> result = new ArrayList<DomCongregation>();
        while (rs.next()) {
            result.add(new DomCongregation(rs, fields));
        }
        return result;
    }

    @Override
    public int create(DomCongregation object) throws SQLException {
        String sql = "{? = call create_congregation(?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setString(2, object.getName());
        cs.setObject(3, (Object)object.getDeaneryId(), 4);
        cs.setString(4, object.getLocation());
        cs.setString(5, object.getEMail());
        cs.setObject(6, (Object)object.getAddressId(), 4);
        cs.execute();
        int id = cs.getInt(1);
        cs.close();
        return id;
    }

    @Override
    public void modify(DomCongregation object) throws SQLException {
        String sql = "{? = call modify_congregation(?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)object.getId(), 4);
        cs.setString(3, object.getName());
        cs.setString(4, object.getLocation());
        cs.setString(5, object.getEMail());
        cs.setObject(6, (Object)object.getAddressId(), 4);
        cs.execute();
        cs.close();
    }

    @Override
    public DomCongregation get(int objectID) throws SQLException, ObjectNotFound {
        String sql = "SELECT *, 0 as automailer_enabled FROM v_congregations WHERE id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, objectID);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            DomCongregation domCongregation = new DomCongregation(rs);
            rs.close();
            return domCongregation;
        }
        rs.close();
        return null;
    }

    public DomCongregation getCashed(int objectId) {
        return this.cashedCongregations.get(objectId);
    }

    public void populateCashedCongs() throws SQLException {
        if (this.cashedCongregations == null) {
            this.cashedCongregations = new HashMap();
        }
        for (DomCongregation cong : MCongregation.listCongregations()) {
            this.cashedCongregations.put(cong.getId(), cong);
        }
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{? = call delete_congregation(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)objectID, 4);
        cs.execute();
        cs.close();
    }

    @Override
    public List<CongregationResult> search(CongregationExpression expression) throws SQLException {
        return null;
    }
}

