/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.MParticipant;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomConfirmation;
import eelk.koguja.model.DomConfirmationHistory;
import eelk.koguja.model.DomParticipant;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.ConfirmationExpression;
import eelk.koguja.search.ConfirmationResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MConfirmation
extends Model<DomConfirmation, ConfirmationExpression, ConfirmationResult> {
    private static MConfirmation theInstance;

    private MConfirmation() {
    }

    public static MConfirmation instance() {
        if (theInstance == null) {
            theInstance = new MConfirmation();
        }
        return theInstance;
    }

    public static DomConfirmation getConfirmationForPerson(Date eventDate, DomPerson person) throws SQLException {
        String sql = "SELECT * FROM v_my_confirmations WHERE person_id IS NULL AND event_date = ? AND person_lastname = ? AND person_firstname = ? AND person_birthdate = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setDate(1, eventDate);
        ps.setString(2, person.getLastName());
        ps.setString(3, person.getFirstName());
        ps.setDate(4, person.getBirthDate());
        ResultSet rs = ps.executeQuery();
        DomConfirmation result = rs.next() ? new DomConfirmation(rs) : null;
        rs.close();
        ps.close();
        return result;
    }

    public static DomConfirmation getConfirmationForPerson(int personId) throws SQLException {
        String sql = "SELECT * FROM v_my_confirmations WHERE person_id = ? ORDER BY event_date DESC";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, personId);
        ResultSet rs = ps.executeQuery();
        DomConfirmation result = rs.next() ? new DomConfirmation(rs) : null;
        rs.close();
        ps.close();
        return result;
    }

    public static boolean isDirty(DomConfirmation confirmation) throws SQLException {
        if (confirmation == null) {
            return false;
        }
        DomConfirmation c = null;
        try {
            c = MConfirmation.instance().get(confirmation.getId());
        }
        catch (ObjectNotFound e) {
            return false;
        }
        return confirmation.getModified_on().before(c.getModified_on());
    }

    public static String getNextDocNr(Integer congregation) throws SQLException {
        String sql = "{? = call get_next_confirmation_doc_nr(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 12);
        cs.setObject(2, (Object)congregation, 4);
        cs.execute();
        String result = cs.getString(1);
        cs.close();
        return result;
    }

    @Override
    public int create(DomConfirmation confirmation) throws SQLException {
        String sql = "{? = call create_confirmation(?, (select get_next_confirmation_doc_nr(?)),?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, Session.current().getCongregation().getId());
        if (confirmation.getCongregationId() == null) {
            cs.setNull(3, 4);
            cs.setNull(4, 4);
        } else {
            cs.setInt(3, (int)confirmation.getCongregationId());
            cs.setInt(4, (int)confirmation.getCongregationId());
        }
        cs.setString(5, confirmation.getCongregationName());
        cs.setDate(6, confirmation.getApplicationDate());
        if (confirmation.getState() == null) {
            cs.setNull(7, 4);
        } else {
            cs.setInt(7, (int)confirmation.getState());
        }
        cs.setDate(8, confirmation.getEventDate());
        cs.setDate(9, confirmation.getEventFuzzyDate());
        cs.setTime(10, confirmation.getEventStart());
        cs.setTime(11, confirmation.getEventEnd());
        cs.setString(12, confirmation.getScripturalPassage());
        cs.setString(13, confirmation.getLegitimation());
        if (confirmation.getOffciantId() == null) {
            cs.setNull(14, 4);
        } else {
            cs.setInt(14, (int)confirmation.getOffciantId());
        }
        if (confirmation.getLocationId() == null) {
            cs.setNull(15, 4);
        } else {
            cs.setInt(15, (int)confirmation.getLocationId());
        }
        cs.setString(16, confirmation.getComment());
        if (confirmation.getPersonId() == null) {
            cs.setNull(17, 4);
        } else {
            cs.setInt(17, (int)confirmation.getPersonId());
        }
        cs.setString(18, confirmation.getMark());
        cs.setString(19, confirmation.getBook());
        cs.setString(20, confirmation.getPage());
        cs.execute();
        int result = cs.getInt(1);
        if (cs.getObject(1) != null) {
            confirmation.setId(result);
        }
        cs.close();
        return result;
    }

    @Override
    public void modify(DomConfirmation confirmation) throws SQLException {
        String sql = "{? = call modify_confirmation(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, confirmation.getId());
        cs.setInt(3, Session.current().getCongregation().getId());
        if (confirmation.getCongregationId() == null) {
            cs.setNull(4, 4);
        } else {
            cs.setInt(4, (int)confirmation.getCongregationId());
        }
        cs.setString(5, confirmation.getCongregationName());
        cs.setDate(6, confirmation.getApplicationDate());
        if (confirmation.getState() == null) {
            cs.setNull(7, 4);
        } else {
            cs.setInt(7, (int)confirmation.getState());
        }
        cs.setDate(8, confirmation.getEventDate());
        cs.setDate(9, confirmation.getEventFuzzyDate());
        cs.setTime(10, confirmation.getEventStart());
        cs.setTime(11, confirmation.getEventEnd());
        cs.setString(12, confirmation.getScripturalPassage());
        cs.setString(13, confirmation.getLegitimation());
        if (confirmation.getOffciantId() == null) {
            cs.setNull(14, 4);
        } else {
            cs.setInt(14, (int)confirmation.getOffciantId());
        }
        if (confirmation.getLocationId() == null) {
            cs.setNull(15, 4);
        } else {
            cs.setInt(15, (int)confirmation.getLocationId());
        }
        cs.setString(16, confirmation.getComment());
        if (confirmation.getPersonId() == null) {
            cs.setNull(17, 4);
        } else {
            cs.setInt(17, (int)confirmation.getPersonId());
        }
        cs.setString(18, confirmation.getMark());
        cs.setString(19, confirmation.getBook());
        cs.setString(20, confirmation.getPage());
        cs.setString(21, confirmation.getModifiedComment());
        cs.execute();
        cs.close();
    }

    @Override
    public DomConfirmation get(int objectID) throws SQLException, ObjectNotFound {
        DomConfirmation result = null;
        String sql = "SELECT * FROM v_my_confirmations WHERE id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, objectID);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = new DomConfirmation(rs);
        }
        rs.close();
        ps.close();
        if (result == null) {
            throw new ObjectNotFound(objectID);
        }
        return result;
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{call delete_confirmation(?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, objectID);
        cs.setInt(2, Session.congregation().getId());
        cs.execute();
        cs.close();
    }

    @Override
    public List<ConfirmationResult> search(ConfirmationExpression e) throws SQLException {
        String sql = "SELECT " + ConfirmationResult.getFields() + "  FROM f_search_confirmation(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setString(1, Util.c((String)e.documentNumberFrom.getValue()));
        ps.setString(2, Util.c((String)e.documentNumberTo.getValue()));
        ps.setObject(3, e.congregation.getValue(), 4);
        ps.setObject(4, e.state.getValue(), 4);
        ps.setObject(5, e.stateExcept.getValue(), 4);
        ps.setDate(6, (Date)e.eventDateStart.getValue());
        ps.setDate(7, (Date)e.eventDateEnd.getValue());
        ps.setDate(8, (Date)e.appDateStart.getValue());
        ps.setDate(9, (Date)e.appDateEnd.getValue());
        ps.setTime(10, (Time)e.eventTimeStart.getValue());
        ps.setTime(11, (Time)e.eventTimeEnd.getValue());
        ps.setObject(12, e.place.getValue(), 4);
        ps.setString(13, Util.metaToDb((String)e.lastName.getValue()));
        ps.setString(14, Util.metaToDb((String)e.firstName.getValue()));
        ps.setDate(15, (Date)e.birthDate.getValue());
        ps.setObject(16, e.ageFrom.getValue(), 4);
        ps.setObject(17, e.ageTo.getValue(), 4);
        ps.setObject(18, e.sex.getValue(), 4);
        ps.setString(19, Util.metaToDb(Util.c((String)e.participantFirstName.getValue())));
        ps.setString(20, Util.metaToDb(Util.c((String)e.participantLastName.getValue())));
        ResultSet rs = ps.executeQuery();
        List<ConfirmationResult> list = ConfirmationResult.fromResultSet(rs);
        rs.close();
        ps.close();
        return list;
    }

    public List<DomParticipant> getParticipants(int confirmationId) throws SQLException {
        String sql = "SELECT * FROM v_confirmations_participants WHERE confirmation_id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, confirmationId);
        ResultSet rs = ps.executeQuery();
        List<DomParticipant> result = MParticipant.fromResultSet(rs, Util.createStringSet("id", "confirmation_id", "person_id", "role_id", "person_firstname", "person_lastname", "person_deathdate"));
        rs.close();
        ps.close();
        return result;
    }

    public void setParticipants(int confirmationId, List<DomParticipant> lstParts) throws SQLException {
        List<DomParticipant> lst = this.getParticipants(confirmationId);
        String insSql = "{? = call create_confirmation_participant(?, ?, ?, ?)}";
        String modSql = "{call modify_confirmation_participant(?, ?, ?, ?, ?)}";
        String delSql = "{call delete_confirmation_participant(?, ?)}";
        for (DomParticipant initPart : lst) {
            if (lstParts.contains(initPart)) continue;
            MParticipant.instance().deleteParticipant(initPart, "{call delete_confirmation_participant(?, ?)}", confirmationId);
        }
        block1: for (DomParticipant part : lstParts) {
            if (!lst.contains(part)) {
                MParticipant.instance().createParticipant(confirmationId, part, "{? = call create_confirmation_participant(?, ?, ?, ?)}");
                continue;
            }
            for (DomParticipant initPart : lst) {
                if (initPart.hasEqualFields(part)) break;
                if (!initPart.equals(part)) continue;
                MParticipant.instance().modifyParticipant(confirmationId, part, "{call modify_confirmation_participant(?, ?, ?, ?, ?)}");
                continue block1;
            }
        }
    }

    public List<DomConfirmationHistory> getConfirmationHistory(int confirmationId) throws SQLException {
        String sql = " SELECT * FROM v_my_confirmations_history WHERE confirmation_id = ? ";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)confirmationId, 4);
        ArrayList<DomConfirmationHistory> result = new ArrayList<DomConfirmationHistory>();
        ResultSet rs = ps.executeQuery();
        Set<String> cols = Util.createStringSet("id", "confirmation_id", "congregation_id", "congregation_name", "application_date", "state", "event_date", "event_date_fuzzy_end", "event_start", "event_end", "donation_id", "scriptural_passage", "legitimation", "officiant_id", "location_id", "comment", "person_id", "person_firstname", "person_lastname", "person_birthdate", "person_code", "mark", "modified_comment", "modified_on", "modified_by", "deleted");
        while (rs.next()) {
            result.add(new DomConfirmationHistory(rs, cols));
        }
        rs.close();
        ps.close();
        return result;
    }
}

