/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.MParticipant;
import eelk.koguja.dao.MPerson;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomBaptism;
import eelk.koguja.model.DomBaptismHistory;
import eelk.koguja.model.DomParticipant;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.BaptismExpression;
import eelk.koguja.search.BaptismResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MBaptism
extends Model<DomBaptism, BaptismExpression, BaptismResult> {
    private static MBaptism theInstance;

    private MBaptism() {
    }

    public static MBaptism instance() {
        if (theInstance == null) {
            theInstance = new MBaptism();
        }
        return theInstance;
    }

    public static DomBaptism getBaptismForPerson(Date eventDate, DomPerson person) throws SQLException {
        String sql = "SELECT * FROM v_my_baptisms WHERE person_id IS NULL AND event_date = ? AND person_lastname = ? AND person_firstname = ? AND person_birthdate = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setDate(1, eventDate);
        ps.setString(2, person.getLastName());
        ps.setString(3, person.getFirstName());
        ps.setDate(4, person.getBirthDate());
        ResultSet rs = ps.executeQuery();
        DomBaptism result = rs.next() ? new DomBaptism(rs) : null;
        rs.close();
        ps.close();
        return result;
    }

    public static DomBaptism getBaptismForPerson(int personId) throws SQLException {
        String sql = "SELECT * FROM v_my_baptisms WHERE person_id = ? ORDER BY event_date DESC";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, personId);
        ResultSet rs = ps.executeQuery();
        DomBaptism result = rs.next() ? new DomBaptism(rs) : null;
        rs.close();
        ps.close();
        return result;
    }

    public static boolean isDirty(DomBaptism baptism) throws SQLException {
        if (baptism == null) {
            return false;
        }
        DomBaptism b = null;
        try {
            b = MBaptism.instance().get(baptism.getId());
        }
        catch (ObjectNotFound e) {
            return false;
        }
        return baptism.getModified_on().before(b.getModified_on());
    }

    public static String getNextDocNr(Integer congregation) throws SQLException {
        String sql = "{? = call get_next_baptism_doc_nr(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 12);
        cs.setObject(2, (Object)congregation, 4);
        cs.execute();
        String result = cs.getString(1);
        cs.close();
        return result;
    }

    @Override
    public int create(DomBaptism baptism) throws SQLException {
        CallableStatement cs;
        String sql;
        if (baptism.location != null && baptism.getLocationId() == null && baptism.location.length() > 0 && baptism.getCongregationId() != null) {
            sql = "{? = call create_location(?, ?)}";
            cs = Session.prepareCall(sql);
            cs.registerOutParameter(1, 4);
            cs.setString(2, baptism.location);
            cs.setInt(3, (int)baptism.getCongregationId());
            cs.execute();
            baptism.setLocationId(cs.getInt(1));
            if (cs.getObject(1) != null) {
                baptism.setLocationId(null);
            }
            cs.close();
        }
        sql = "{? = call create_baptism(?, (select get_next_baptism_doc_nr(?)),?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, Session.current().getCongregation().getId());
        if (baptism.getCongregationId() == null) {
            cs.setNull(3, 4);
            cs.setNull(4, 4);
        } else {
            cs.setInt(3, (int)baptism.getCongregationId());
            cs.setInt(4, (int)baptism.getCongregationId());
        }
        cs.setString(5, baptism.getCongregationName());
        cs.setDate(6, baptism.getApplicationDate());
        if (baptism.getState() == null) {
            cs.setNull(7, 4);
        } else {
            cs.setInt(7, (int)baptism.getState());
        }
        cs.setDate(8, baptism.getEventDate());
        cs.setDate(9, baptism.getEventFuzzyDate());
        cs.setTime(10, baptism.getEventStart());
        cs.setTime(11, baptism.getEventEnd());
        cs.setString(12, baptism.getScripturalPassage());
        cs.setString(13, baptism.getLegitimation());
        if (baptism.getOffciantId() == null) {
            cs.setNull(14, 4);
        } else {
            cs.setInt(14, (int)baptism.getOffciantId());
        }
        if (baptism.getLocationId() == null) {
            cs.setNull(15, 4);
        } else {
            cs.setInt(15, (int)baptism.getLocationId());
        }
        cs.setString(16, baptism.getComment());
        if (baptism.getPersonId() == null) {
            cs.setNull(17, 4);
        } else {
            cs.setInt(17, (int)baptism.getPersonId());
        }
        if (baptism.isGodFather() == null) {
            cs.setNull(18, 16);
        } else {
            cs.setBoolean(18, (boolean)baptism.isGodFather());
        }
        cs.setString(19, baptism.getBook());
        cs.setString(20, baptism.getPage());
        cs.execute();
        int result = cs.getInt(1);
        if (cs.getObject(1) != null) {
            baptism.setId(result);
        }
        cs.close();
        return result;
    }

    @Override
    public DomBaptism get(int objectID) throws SQLException, ObjectNotFound {
        DomBaptism result = null;
        String sql = "SELECT * FROM v_my_baptisms WHERE id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, objectID);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = new DomBaptism(rs);
        }
        rs.close();
        ps.close();
        if (result == null) {
            throw new ObjectNotFound(objectID);
        }
        return result;
    }

    @Override
    public void modify(DomBaptism baptism) throws SQLException {
        String sql = "{? = call modify_baptism(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, baptism.getId());
        cs.setInt(3, Session.current().getCongregation().getId());
        if (baptism.getCongregationId() == null) {
            cs.setNull(4, 4);
        } else {
            cs.setInt(4, (int)baptism.getCongregationId());
        }
        cs.setString(5, baptism.getCongregationName());
        cs.setDate(6, baptism.getApplicationDate());
        if (baptism.getState() == null) {
            cs.setNull(7, 4);
        } else {
            cs.setInt(7, (int)baptism.getState());
        }
        cs.setDate(8, baptism.getEventDate());
        cs.setDate(9, baptism.getEventFuzzyDate());
        cs.setTime(10, baptism.getEventStart());
        cs.setTime(11, baptism.getEventEnd());
        cs.setString(12, baptism.getScripturalPassage());
        cs.setString(13, baptism.getLegitimation());
        if (baptism.getOffciantId() == null) {
            cs.setNull(14, 4);
        } else {
            cs.setInt(14, (int)baptism.getOffciantId());
        }
        if (baptism.getLocationId() == null) {
            cs.setNull(15, 4);
        } else {
            cs.setInt(15, (int)baptism.getLocationId());
        }
        cs.setString(16, baptism.getComment());
        if (baptism.getPersonId() == null) {
            cs.setNull(17, 4);
        } else {
            cs.setInt(17, (int)baptism.getPersonId());
        }
        if (baptism.isGodFather() == null) {
            cs.setNull(18, 16);
        } else {
            cs.setBoolean(18, (boolean)baptism.isGodFather());
        }
        cs.setString(19, baptism.getBook());
        cs.setString(20, baptism.getPage());
        cs.setString(21, baptism.getModifiedComment());
        cs.execute();
        cs.close();
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{call delete_baptism(?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, objectID);
        cs.setInt(2, Session.congregation().getId());
        cs.execute();
        cs.close();
    }

    @Override
    public List<BaptismResult> search(BaptismExpression e) throws SQLException {
        String sql = " SELECT " + BaptismResult.getFields() + " FROM f_search_baptism(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setString(1, Util.c((String)e.documentNumberFrom.getValue()));
        ps.setString(2, Util.c((String)e.documentNumberTo.getValue()));
        ps.setObject(3, e.congregation.getValue(), 4);
        ps.setObject(4, e.state.getValue(), 4);
        ps.setObject(5, e.stateExcept.getValue(), 4);
        ps.setDate(6, (Date)e.eventDateStart.getValue());
        ps.setDate(7, (Date)e.eventDateEnd.getValue());
        ps.setDate(8, (Date)e.appDateStart.getValue());
        ps.setDate(9, (Date)e.appDateEnd.getValue());
        ps.setTime(10, (Time)e.eventTimeStart.getValue());
        ps.setTime(11, (Time)e.eventTimeEnd.getValue());
        ps.setObject(12, e.place.getValue(), 4);
        ps.setString(13, Util.metaToDb((String)e.lastName.getValue()));
        ps.setString(14, Util.metaToDb((String)e.firstName.getValue()));
        ps.setDate(15, (Date)e.birthDate.getValue());
        ps.setObject(16, e.ageFrom.getValue(), 4);
        ps.setObject(17, e.ageTo.getValue(), 4);
        ps.setObject(18, e.sex.getValue(), 4);
        ps.setString(19, Util.metaToDb(Util.c((String)e.participantFirstName.getValue())));
        ps.setString(20, Util.metaToDb(Util.c((String)e.participantLastName.getValue())));
        ResultSet rs = ps.executeQuery();
        List<BaptismResult> list = BaptismResult.fromResultSet(rs);
        rs.close();
        ps.close();
        return list;
    }

    public List<DomParticipant> getParticipants(int baptismId) throws SQLException {
        String sql = "SELECT * FROM v_baptisms_participants WHERE baptism_id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, baptismId);
        ResultSet rs = ps.executeQuery();
        List<DomParticipant> result = MParticipant.fromResultSet(rs, Util.createStringSet("id", "baptism_id", "person_id", "role_id", "person_firstname", "person_lastname", "person_deathdate"));
        rs.close();
        ps.close();
        return result;
    }

    public void setParticipants(int baptismId, List<DomParticipant> lstParts) throws SQLException {
        List<DomParticipant> lst = this.getParticipants(baptismId);
        String insSql = "{? = call create_baptism_participant(?, ?, ?, ?)}";
        String modSql = "{call modify_baptism_participant(?, ?, ?, ?, ?)}";
        String delSql = "{call delete_baptism_participant(?, ?)}";
        for (DomParticipant initPart : lst) {
            if (lstParts.contains(initPart)) continue;
            MParticipant.instance().deleteParticipant(initPart, "{call delete_baptism_participant(?, ?)}", baptismId);
        }
        block1: for (DomParticipant part : lstParts) {
            if (!lst.contains(part)) {
                MParticipant.instance().createParticipant(baptismId, part, "{? = call create_baptism_participant(?, ?, ?, ?)}");
                continue;
            }
            for (DomParticipant initPart : lst) {
                if (initPart.hasEqualFields(part)) break;
                if (!initPart.equals(part)) continue;
                MParticipant.instance().modifyParticipant(baptismId, part, "{call modify_baptism_participant(?, ?, ?, ?, ?)}");
                continue block1;
            }
        }
    }

    public List<DomPerson> getGodParents(int baptismId) throws SQLException {
        String sql = "SELECT * FROM v_baptisms_godparents WHERE baptism_id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, baptismId);
        ResultSet rs = ps.executeQuery();
        List<DomPerson> result = MPerson.fromResultSet(rs, Util.createStringSet("id", "firstname", "lastname"));
        rs.close();
        ps.close();
        return result;
    }

    public List<DomBaptismHistory> getBaptismHistory(int baptismId) throws SQLException {
        String sql = " SELECT * FROM v_my_baptisms_history WHERE baptism_id = ? ";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)baptismId, 4);
        ArrayList<DomBaptismHistory> result = new ArrayList<DomBaptismHistory>();
        ResultSet rs = ps.executeQuery();
        Set<String> cols = Util.createStringSet("id", "baptism_id", "congregation_id", "congregation_name", "application_date", "state", "event_date", "event_date_fuzzy_end", "event_start", "event_end", "donation_id", "scriptural_passage", "legitimation", "officiant_id", "location_id", "comment", "person_id", "person_firstname", "person_lastname", "person_birthdate", "person_code", "is_godfather", "modified_comment", "modified_on", "modified_by", "deleted");
        while (rs.next()) {
            result.add(new DomBaptismHistory(rs, cols));
        }
        rs.close();
        ps.close();
        return result;
    }

    public void setGodParents(int baptismId, List<DomPerson> lstGodParents) throws SQLException {
        List<DomPerson> lst = this.getGodParents(baptismId);
        String sql = "{call remove_baptism_godparent(?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(3, Session.congregation().getId());
        for (DomPerson person : lst) {
            if (lstGodParents.contains(person)) continue;
            cs.setInt(1, baptismId);
            cs.setInt(2, person.getId());
            cs.execute();
        }
        cs.close();
        sql = "{call add_baptism_godparent(?, ?, ?)}";
        cs = Session.prepareCall(sql);
        cs.setInt(3, Session.congregation().getId());
        for (DomPerson person : lstGodParents) {
            if (lst.contains(person)) continue;
            cs.setInt(1, baptismId);
            cs.setInt(2, person.getId());
            cs.execute();
        }
        cs.close();
    }
}

