/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomAttribute;
import eelk.koguja.model.DomAttributeSearch;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.AttributeExpression;
import eelk.koguja.search.AttributeResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class MAttribute
extends Model<DomAttribute, AttributeExpression, AttributeResult> {
    private static MAttribute theInstance;
    private HashMap<Integer, DomAttributeSearch> cashedSearchAttributes;

    private MAttribute() {
    }

    public static MAttribute instance() {
        if (theInstance == null) {
            theInstance = new MAttribute();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DomAttribute> listAttributes() throws SQLException {
        String sql = "SELECT   id, rank, name FROM v_attributes ORDER BY rank ASC, name ASC";
        ResultSet rs = null;
        List<DomAttribute> lst = null;
        PreparedStatement ps = Session.prepareStatement(sql);
        try {
            rs = ps.executeQuery();
            lst = MAttribute.fromResultSet(rs, Util.createStringSet("id", "rank", "name"));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            ps.close();
        }
        return lst;
    }

    public static List<DomAttributeSearch> listAttributesForSearch() throws SQLException {
        String sql = "SELECT   id, rank, name, false as used_in_search, false as is_yes FROM v_attributes ORDER BY rank ASC, name ASC";
        ArrayList<DomAttributeSearch> lst = new ArrayList<DomAttributeSearch>();
        try (PreparedStatement ps = Session.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                lst.add(new DomAttributeSearch(rs, Util.createStringSet("id", "rank", "name", "used_in_search", "is_yes")));
            }
        }
        return lst;
    }

    public static List<DomAttribute> fromResultSet(ResultSet rs, Set<String> fields) throws SQLException {
        ArrayList<DomAttribute> result = new ArrayList<DomAttribute>();
        while (rs.next()) {
            result.add(new DomAttribute(rs, fields));
        }
        return result;
    }

    @Override
    public int create(DomAttribute object) throws SQLException {
        String sql = "{? = call create_attribute(?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)object.getRank(), 4);
        cs.setString(3, object.getName());
        cs.execute();
        int result = cs.getInt(1);
        cs.close();
        return result;
    }

    @Override
    public DomAttribute get(int objectID) throws SQLException, ObjectNotFound {
        return null;
    }

    @Override
    public void modify(DomAttribute object) throws SQLException {
        String sql = "{? = call modify_attribute(?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)object.getId(), 4);
        cs.setObject(3, (Object)object.getRank(), 4);
        cs.setString(4, object.getName());
        cs.execute();
        cs.close();
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{? = call delete_attribute(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)objectID, 4);
        cs.execute();
        cs.close();
    }

    public DomAttributeSearch getCashed(int objectId) {
        return this.cashedSearchAttributes.get(objectId);
    }

    public void populateCashedSearchAttributes() throws SQLException {
        if (this.cashedSearchAttributes == null) {
            this.cashedSearchAttributes = new HashMap();
        }
        for (DomAttributeSearch attr : MAttribute.listAttributesForSearch()) {
            this.cashedSearchAttributes.put(attr.getId(), attr);
        }
    }

    @Override
    public List<AttributeResult> search(AttributeExpression expression) throws SQLException {
        return null;
    }

    public List<DomAttributeSearch> getCashedSearchAttributes() {
        ArrayList<DomAttributeSearch> resultList = new ArrayList<DomAttributeSearch>();
        for (Integer key : this.cashedSearchAttributes.keySet()) {
            resultList.add(this.cashedSearchAttributes.get(key).clone());
        }
        Collections.sort(resultList);
        return resultList;
    }
}

