/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.AddressExpression;
import eelk.koguja.search.AddressResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MAddress
extends Model<DomAddress, AddressExpression, AddressResult> {
    private static MAddress theInstance;

    private MAddress() {
    }

    public static MAddress instance() {
        if (theInstance == null) {
            theInstance = new MAddress();
        }
        return theInstance;
    }

    @Override
    public int create(DomAddress address) throws SQLException {
        String sql = "{? = call create_address(?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setString(2, address.getCountry());
        cs.setString(3, address.getCounty());
        cs.setString(4, address.getCity());
        cs.setString(5, address.getStreet());
        cs.setString(6, address.getHouse());
        cs.setString(7, address.getPostcode());
        cs.setString(8, address.getPhone());
        cs.setString(9, address.getComment());
        cs.setInt(10, Session.congregation().getId());
        cs.execute();
        address.setId(cs.getObject(1) == null ? -1 : cs.getInt(1));
        cs.close();
        return address.getId();
    }

    @Override
    public DomAddress get(int addressId) throws SQLException, ObjectNotFound {
        String sql = "SELECT * FROM v_address WHERE id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, addressId);
        ResultSet rs = ps.executeQuery();
        DomAddress result = null;
        if (rs.next()) {
            result = new DomAddress(rs);
        }
        rs.close();
        ps.close();
        if (result == null) {
            throw new ObjectNotFound(addressId);
        }
        return result;
    }

    @Override
    public void modify(DomAddress address) throws SQLException {
        String sql = "{? = call modify_address(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, address.getId());
        cs.setString(3, address.getCountry());
        cs.setString(4, address.getCounty());
        cs.setString(5, address.getCity());
        cs.setString(6, address.getStreet());
        cs.setString(7, address.getHouse());
        cs.setString(8, address.getPostcode());
        cs.setString(9, address.getPhone());
        cs.setString(10, address.getComment());
        cs.setInt(11, Session.congregation().getId());
        cs.execute();
        cs.close();
    }

    @Override
    public void delete(int addressId) throws SQLException, ObjectNotFound {
        String sql = "{call delete_address(?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, addressId);
        cs.setInt(2, Session.congregation().getId());
        cs.execute();
        cs.close();
    }

    @Override
    public List<AddressResult> search(AddressExpression expression) throws SQLException {
        return null;
    }

    public List<DomAddress> listRelativesAddresses(int personId) throws SQLException {
        String sql = "SELECT * FROM v_relatives_addresses WHERE person_id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, personId);
        ResultSet rs = ps.executeQuery();
        List<DomAddress> result = this.fromResultSet(rs, Util.createStringSet("id", "country", "county", "city", "street", "house", "postcode", "phone", "comment"));
        rs.close();
        ps.close();
        return result;
    }

    public List<DomAddress> fromResultSet(ResultSet rs, Set<String> fields) throws SQLException {
        ArrayList<DomAddress> result = new ArrayList<DomAddress>();
        while (rs.next()) {
            result.add(new DomAddress(rs, fields));
        }
        return result;
    }

    @Deprecated
    public int getAddressUsedCount(int addressId) throws SQLException {
        String sql = "{? = call get_address_used_count(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, addressId);
        cs.execute();
        int result = cs.getObject(1) == null ? 0 : cs.getInt(1);
        cs.close();
        return result;
    }
}

