/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.action;

import eelk.koguja.Session;
import eelk.koguja.action.AAbstractAction;
import eelk.koguja.action.AEditMerge;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dao.MRelationship;
import eelk.koguja.dlg.DlgMain;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomPersonAddress;
import eelk.koguja.model.DomRelationship;
import eelk.koguja.search.Result;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.ImageFactory;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VMain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public class ACreateFamily
extends AAbstractAction {
    public ACreateFamily(DlgMain dlgMain, String text) {
        super(dlgMain, text);
        this.setImageDescriptor(ImageFactory.getImageDescriptor(ImageFactory.ImageCollection.FAMILY));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        List<Result> results = DlgMain.instance().getVMain().getSelectedResults(VMain.SearchMode.PERSON);
        if (results.size() < 3) {
            GuiUtil.informationDialog(this.getShell(), "Msg.PersonResult.NonTripleSel", new Object[0]);
            return;
        }
        Collections.sort(results, new Comparator<Result>(){

            @Override
            public int compare(Result o1, Result o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                try {
                    DomPerson person1 = MPersonSwt.instance().get(o1.getId());
                    DomPerson person2 = MPersonSwt.instance().get(o2.getId());
                    return person1.getBirthDate().compareTo(person2.getBirthDate());
                }
                catch (Exception e) {
                    SwtExceptionHandler.instance().Ex(e, Logger.getLogger(AEditMerge.class), Resources.getErrString("Search"), new Object[0]);
                    return 0;
                }
            }
        });
        try {
            void var9_14;
            String[] buttons;
            DomPerson father = null;
            DomPerson mother = null;
            ArrayList<DomPerson> homelessPersons = new ArrayList<DomPerson>();
            DomPerson addressedPerson = null;
            ArrayList<DomPerson> children = new ArrayList<DomPerson>();
            DomAddress familyAddress = null;
            for (Result result : results) {
                DomPerson person = MPersonSwt.instance().get(result.getId());
                if (familyAddress == null) {
                    familyAddress = MPersonSwt.instance().getPersonsActiveAddress(person.getId());
                    if (familyAddress != null) {
                        addressedPerson = person;
                    } else {
                        homelessPersons.add(person);
                    }
                } else {
                    homelessPersons.add(person);
                }
                if (person.getSex() == 0 && father == null) {
                    father = person;
                    continue;
                }
                if (person.getSex() != 0 && mother == null) {
                    mother = person;
                    continue;
                }
                children.add(person);
            }
            if (father == null || mother == null || children.size() < 1) {
                GuiUtil.informationDialog(this.getShell(), "Msg.PersonResult.NonFamilySel", new Object[0]);
                return;
            }
            StringBuilder family = new StringBuilder(father.getFirstName() + " " + father.getLastName() + "\t- " + Resources.getString("VPersonPreview.lblFather") + "\n" + mother.getFirstName() + " " + mother.getLastName() + "\t- " + Resources.getString("VPersonPreview.lblMother") + "");
            for (DomPerson child : children) {
                family.append("\n").append(child.getFirstName()).append(" ").append(child.getLastName()).append("\t- ").append(child.getSex() == 0 ? Resources.getString("VPersonPreview.lblSon") : Resources.getString("VPersonPreview.lblDaughter"));
            }
            if (familyAddress != null) {
                buttons = new String[]{Resources.getMsgString("PersonResult.CreateFamily.ChangeAddress"), Resources.getMsgString("PersonResult.CreateFamily.RelationsOnly"), Resources.getGenString("Cancel")};
                int n = GuiUtil.confirmationDialog(this.getShell(), "Msg.PersonResult.CreateFamily", buttons, 2, family.toString(), familyAddress);
            } else {
                buttons = new String[]{Resources.getGenString("Yes"), Resources.getGenString("No")};
                int n = GuiUtil.confirmationDialog(this.getShell(), "Msg.PersonResult.CreateFamily.NoAddress", buttons, 1, family.toString());
            }
            if (var9_14 == false || var9_14 == true && familyAddress != null) {
                List<DomRelationship> rels1 = MRelationship.listMyRelationships(father.getId());
                boolean createWife = true;
                for (DomRelationship relationship : rels1) {
                    if (relationship.getTypeId() != 2) break;
                    if ((relationship.getPerson1Id().intValue() != father.getId() || relationship.getPerson2Id().intValue() != mother.getId()) && (relationship.getPerson2Id().intValue() != father.getId() || relationship.getPerson1Id().intValue() != mother.getId())) continue;
                    createWife = false;
                    break;
                }
                if (createWife) {
                    DomRelationship r = new DomRelationship();
                    r.setPerson1Id(father.getId());
                    r.setPerson2Id(mother.getId());
                    r.setTypeId(2);
                    MRelationship.instance().set(r);
                }
                boolean createHusband = true;
                List<DomRelationship> rels2 = MRelationship.listMyRelationships(mother.getId());
                for (DomRelationship relationship : rels2) {
                    if (relationship.getTypeId() != 2) break;
                    if ((relationship.getPerson1Id().intValue() != father.getId() || relationship.getPerson2Id().intValue() != mother.getId()) && (relationship.getPerson2Id().intValue() != father.getId() || relationship.getPerson1Id().intValue() != mother.getId())) continue;
                    createHusband = false;
                }
                if (createHusband) {
                    DomRelationship r = new DomRelationship();
                    r.setPerson1Id(mother.getId());
                    r.setPerson2Id(father.getId());
                    r.setTypeId(2);
                    MRelationship.instance().set(r);
                }
                for (DomPerson child : children) {
                    DomRelationship r;
                    List<DomRelationship> rels = MRelationship.listMyRelationships(child.getId());
                    boolean createFatherRS = true;
                    boolean createMotherRS = true;
                    for (DomRelationship relationship : rels) {
                        if (relationship.getTypeId() != 1) continue;
                        if (relationship.getPerson1Id().intValue() == father.getId() && relationship.getPerson2Id().intValue() == child.getId() || relationship.getPerson2Id().intValue() == father.getId() && relationship.getPerson1Id().intValue() == child.getId()) {
                            createFatherRS = false;
                        }
                        if (relationship.getPerson1Id().intValue() == child.getId() && relationship.getPerson2Id().intValue() == mother.getId() || relationship.getPerson2Id().intValue() == child.getId() && relationship.getPerson1Id().intValue() == mother.getId()) {
                            createMotherRS = false;
                        }
                        if (createFatherRS || createMotherRS) continue;
                        break;
                    }
                    if (createFatherRS) {
                        r = new DomRelationship();
                        r.setPerson1Id(child.getId());
                        r.setPerson2Id(father.getId());
                        r.setTypeId(1);
                        MRelationship.instance().set(r);
                    }
                    if (createMotherRS) {
                        r = new DomRelationship();
                        r.setPerson1Id(mother.getId());
                        r.setPerson2Id(child.getId());
                        r.setTypeId(1);
                        MRelationship.instance().set(r);
                    }
                    for (DomPerson sibling : children) {
                        if (child.getId() == sibling.getId()) continue;
                        List<DomRelationship> childrels = MRelationship.listMyRelationships(child.getId());
                        boolean createSiblingRS = true;
                        for (DomRelationship relationship : childrels) {
                            if (relationship.getTypeId() != 3 || (relationship.getPerson1Id().intValue() != sibling.getId() || relationship.getPerson2Id().intValue() != child.getId()) && (relationship.getPerson2Id().intValue() != sibling.getId() || relationship.getPerson1Id().intValue() != child.getId())) continue;
                            createSiblingRS = false;
                            break;
                        }
                        if (!createSiblingRS) continue;
                        DomRelationship r2 = new DomRelationship();
                        r2.setPerson1Id(child.getId());
                        r2.setPerson2Id(sibling.getId());
                        r2.setTypeId(3);
                        MRelationship.instance().set(r2);
                    }
                }
            }
            if (var9_14 == false && familyAddress != null) {
                ArrayList<DomPersonAddress> addresses = new ArrayList<DomPersonAddress>();
                addresses.add(new DomPersonAddress(addressedPerson.getId(), familyAddress));
                for (DomPerson hobo : homelessPersons) {
                    MPersonSwt.setPersonAddresses(hobo.getId(), addresses);
                }
            }
            Session.connection().commit();
        }
        catch (Exception e) {
            Session.rollback();
            SwtExceptionHandler.instance().Ex(e, Logger.getLogger(AEditMerge.class), Resources.getErrString("Search"), new Object[0]);
        }
    }
}

