/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja;

import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomConnection;
import eelk.koguja.sql.ConnectionRefresher;
import eelk.koguja.sql.LoggedConnection;
import eelk.koguja.util.Resources;
import eelk.koguja.util.iExceptionHandler;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Session {
    private static final Logger logger = Logger.getLogger(Session.class);
    private static Session current;
    private static Statement lastStatement;
    private Connection connection;
    private String username;
    private DomCongregation congregation;
    private final ConnectionRefresher connectionRefresher = new ConnectionRefresher();
    private SearchMode mode;
    private List<DomCongregation> congs;

    private Session() {
    }

    public static DomCongregation congregation() {
        Session c = Session.current();
        if (c == null) {
            return null;
        }
        return c.getCongregation();
    }

    public static Session createSession(DomConnection conn, Properties prop) throws SQLException {
        String c = conn.toString();
        logger.info("Trying to open connection to [" + c + "]");
        Connection con = DriverManager.getConnection(c, prop);
        logger.info("Connection succeeded");
        current = new Session();
        Session.current.username = conn.getDatabaseUser();
        boolean logActivity = Boolean.valueOf(System.getProperty("db.log"));
        Session.current.connection = logActivity ? new LoggedConnection(con) : con;
        String a = System.getProperty("import.autocommit");
        Session.current.connection.setAutoCommit(a != null && a.equals("true"));
        DatabaseMetaData dm = Session.current.connection.getMetaData();
        logger.info("Driver name: " + dm.getDriverName());
        logger.info("Driver version: " + dm.getDriverVersion());
        logger.info("Product name: " + dm.getDatabaseProductName());
        logger.info("Product version: " + dm.getDatabaseProductVersion());
        Statement s = Session.current.connection.createStatement();
        ResultSet rs = s.executeQuery("SHOW client_encoding");
        if (rs.next()) {
            logger.debug("Client encoding is " + rs.getObject(1));
        }
        rs.close();
        s.close();
        current.setMode(SearchMode.PERSON);
        return current;
    }

    public static Session createSession(DomConnection conn, String username, String password) throws SQLException {
        Properties p = new Properties();
        if (username != null && !"".equals(username)) {
            conn.setDatabaseUser(username);
        }
        p.put("password", password);
        return Session.createSession(conn, p);
    }

    public static Session createSession(DomConnection conn, String username, String password, String host, String port, String db, String ssl) throws SQLException {
        Properties p = new Properties();
        if (username != null && !"".equals(username)) {
            conn.setDatabaseUser(username);
        }
        p.put("password", password);
        if (host != null && !"".equals(host)) {
            conn.setHost(host);
        }
        if (port != null && !"".equals(port)) {
            conn.setPort(port);
        }
        if (db != null && !"".equals(db)) {
            conn.setDatabaseName(db);
        }
        if (ssl != null && !"".equals(ssl)) {
            if (!"no".equals(ssl) && !"false".equals(ssl)) {
                conn.setHasSsl(true);
            } else {
                conn.setHasSsl(false);
            }
        }
        return Session.createSession(conn, p);
    }

    public static void closeCurrent() throws SQLException {
        Session s = Session.current();
        if (s == null) {
            return;
        }
        s.close();
        current = null;
    }

    public static Session current() {
        return current;
    }

    public static Connection connection() {
        Session s = Session.current();
        if (s == null) {
            return null;
        }
        return s.getConnection();
    }

    public static void rollback() {
        Connection c = Session.connection();
        if (c == null) {
            return;
        }
        try {
            c.rollback();
        }
        catch (SQLException e) {
            iExceptionHandler.handleException((Throwable)e, logger, null, Resources.getErrString("Rollback"), new Object[0]);
        }
    }

    public static PreparedStatement prepareStatement(String sql) throws SQLException {
        logger.debug("prepareStatement: " + sql);
        lastStatement = Session.connection().prepareStatement(sql);
        return (PreparedStatement)lastStatement;
    }

    public static CallableStatement prepareCall(String sql) throws SQLException {
        logger.debug("prepareCall: " + sql);
        lastStatement = Session.connection().prepareCall(sql);
        return (CallableStatement)lastStatement;
    }

    public static Statement getLastStatement() {
        return lastStatement;
    }

    public static boolean loadDriver(DomConnection conn) {
        String driver = conn.getDriver();
        if (driver == null) {
            driver = "";
        }
        try {
            logger.info("Register db driver: " + driver);
            Class.forName(driver);
            return true;
        }
        catch (ClassNotFoundException e) {
            iExceptionHandler.handleException((Throwable)e, logger, null, Resources.getErrString("JDBC.Load"), driver);
            return false;
        }
    }

    public Connection getConnection() {
        this.connectionRefresher.queryExecuted();
        return this.connection;
    }

    public void close() throws SQLException {
        Connection c = this.getConnection();
        if (c == null) {
            return;
        }
        this.connectionRefresher.terminate();
        logger.info("Closing database session");
        c.close();
    }

    public String getUsername() {
        return this.username;
    }

    public DomCongregation getCongregation() {
        return this.congregation;
    }

    public void setCongregation(DomCongregation congregation) {
        this.congregation = congregation;
    }

    public SearchMode getMode() {
        return this.mode;
    }

    public void setMode(SearchMode mode) {
        if (this.getMode() != null && this.getMode().getMode() == mode.getMode()) {
            return;
        }
        this.mode = mode;
    }

    public List<DomCongregation> getCongs() {
        return this.congs;
    }

    public void setCongs(List<DomCongregation> congs) {
        this.congs = congs;
    }

    public static enum SearchMode {
        BAPTISM(0, "baptism"),
        CONFIRMATION(1, "confirmation"),
        DONATION(2, "donation"),
        FUNERAL(3, "funeral"),
        PERSON(4, "person"),
        WEDDING(5, "wedding");

        private final int mode;
        private final String name;

        private SearchMode(int mode, String name) {
            this.mode = mode;
            this.name = name;
        }

        public int getMode() {
            return this.mode;
        }

        public String getName() {
            return this.name;
        }
    }
}

