/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja;

import eelk.koguja.Session;
import eelk.koguja.dlg.DlgMain;
import eelk.koguja.model.DomConnection;
import eelk.koguja.preference.IPreferenceStore;
import eelk.koguja.preference.MConnection;
import eelk.koguja.preference.Preferences;
import eelk.koguja.util.Resources;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.util.Locale;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.swt.widgets.Display;

public final class Launch {
    public static Logger logger;

    private static void setSSLFactories(String keyStoreName, String keyStorePassword, String trustStoreName) {
        try {
            Class<Launch> a = Launch.class;
            URL[] path = new URL[]{new File("").toURI().toURL()};
            URLClassLoader urlClassLoader = new URLClassLoader(path, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] keyPassword = keyStorePassword.toCharArray();
            InputStream keyStream = a.getResourceAsStream(keyStoreName);
            if (keyStream == null) {
                keyStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(keyStoreName.substring(1));
            }
            keyStore.load(keyStream, keyPassword);
            if (keyStream != null) {
                keyStream.close();
            }
            KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyFactory.init(keyStore, keyPassword);
            KeyManager[] keyManagers = keyFactory.getKeyManagers();
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] trustPassword = keyStorePassword.toCharArray();
            InputStream trustStream = a.getResourceAsStream(trustStoreName);
            if (trustStream == null) {
                trustStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(trustStoreName.substring(1));
            }
            trustStore.load(trustStream, trustPassword);
            if (trustStream != null) {
                trustStream.close();
            }
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustFactory.init(trustStore);
            TrustManager[] trustManagers = trustFactory.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(keyManagers, trustManagers, null);
            SSLContext.setDefault(sslContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initProp(String key, String val) {
        Properties systemProps = System.getProperties();
        if (systemProps.getProperty(key) == null) {
            IPreferenceStore store = Preferences.getStore();
            if (store.contains(key) && store.getString(key).length() > 0) {
                systemProps.put(key, store.getString(key));
            } else {
                systemProps.put(key, val);
            }
            System.setProperties(systemProps);
        }
    }

    public static void main(String[] args) {
        Launch.configureLogger();
        Launch.initProp("key.store", "/cert/ca.jks");
        Launch.initProp("key.store", "/cert/ca.jks");
        Launch.initProp("trust.store", "/cert/ca.jks");
        Launch.initProp("store.pass", "kasutaja");
        Launch.initProp("user.language", "et");
        Launch.initProp("user.country", "EE");
        Properties systemProps = System.getProperties();
        logger.info("Application started");
        logger.info("Version: " + Launch.class.getPackage().getImplementationVersion());
        logger.info("OS: " + systemProps.getProperty("os.name") + " " + systemProps.getProperty("os.arch") + " " + systemProps.getProperty("os.version"));
        logger.info("Java: " + systemProps.getProperty("java.vendor") + " " + systemProps.getProperty("java.version"));
        logger.info("Java Home: " + systemProps.getProperty("java.home"));
        logger.info("User: " + systemProps.getProperty("user.name") + " " + systemProps.getProperty("user.home"));
        logger.info("App Started from: " + systemProps.getProperty("user.dir"));
        logger.info("Locale: " + systemProps.getProperty("user.language") + "_" + systemProps.getProperty("user.country"));
        Locale locale = Locale.getDefault();
        String lang = locale.getDisplayLanguage();
        String country = locale.getDisplayCountry();
        logger.info("System Locale: " + lang + "_" + country);
        Launch.setSSLFactories(systemProps.getProperty("key.store"), systemProps.getProperty("store.pass"), systemProps.getProperty("trust.store"));
        if (Launch.onStartUp(args)) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.debug("Run koguja main thread");
                        Display.setAppName((String)"Koguja");
                        DlgMain.instance().open();
                        Launch.shutDown();
                        System.exit(0);
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
            };
            r.run();
        }
    }

    private static void configureLogger() {
        Launch.initProp("log4j.configuration", "/eelk/koguja/conf/log4j.properties");
        try {
            String p = System.getProperty("log4j.configuration");
            InputStream stream = Launch.class.getResourceAsStream(p);
            if (stream == null) {
                stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(p.substring(1));
            }
            PropertyConfigurator.configure(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger = Logger.getLogger(Launch.class);
    }

    public static void shutDown() {
        logger.debug("Application shutdown requested");
        if (Launch.onShutDown()) {
            logger.info("Application shuts down");
            try {
                Display.getCurrent().dispose();
            }
            catch (Exception exception) {}
        } else {
            logger.debug("Application shutdown refused");
        }
    }

    protected static boolean onStartUp(String[] args) {
        DomConnection conn = new DomConnection();
        MConnection.instance().load(conn);
        MConnection.instance().init(conn);
        if (!Resources.loadResources()) {
            return false;
        }
        return Session.loadDriver(conn);
    }

    protected static boolean onShutDown() {
        DlgMain.instance().getVMain().getSearchComposite().storeSearchPrefs();
        Preferences.save();
        return true;
    }
}

