/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.IReportViewerListener;
import com.jasperassistant.designer.viewer.ReportViewerEvent;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.text.DecimalFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ZoomComboContributionItem
extends ContributionItem
implements IReportViewerListener,
Listener {
    private static final DecimalFormat ZOOM_FORMAT = new DecimalFormat("####%");
    private IReportViewer viewer;
    private Combo combo;
    private double[] zoomLevels;

    public ZoomComboContributionItem(IReportViewer viewer) {
        Assert.isNotNull(viewer);
        this.viewer = viewer;
        this.viewer.addReportViewerListener(this);
        this.refresh();
    }

    private void refresh() {
        block8: {
            if (this.combo == null || this.combo.isDisposed()) {
                return;
            }
            try {
                if (!this.viewer.canChangeZoom()) {
                    this.combo.setEnabled(false);
                    this.combo.setText("");
                } else {
                    String zoom;
                    int index;
                    this.combo.removeListener(13, (Listener)this);
                    this.combo.removeListener(14, (Listener)this);
                    if (this.zoomLevels != this.viewer.getZoomLevels()) {
                        this.zoomLevels = this.viewer.getZoomLevels();
                        this.combo.setItems(this.getZoomLevelsAsText());
                    }
                    if ((index = this.combo.indexOf(zoom = this.getZoomAsText())) != -1) {
                        this.combo.select(index);
                    } else {
                        this.combo.setText(zoom);
                    }
                    this.combo.setEnabled(true);
                    this.combo.addListener(13, (Listener)this);
                    this.combo.addListener(14, (Listener)this);
                }
            }
            catch (SWTException exception) {
                if (SWT.getPlatform().equals("gtk")) break block8;
                throw exception;
            }
        }
    }

    private String[] getZoomLevelsAsText() {
        if (this.zoomLevels == null) {
            return new String[]{"100%"};
        }
        String[] textZoomLevels = new String[this.zoomLevels.length];
        for (int i = 0; i < textZoomLevels.length; ++i) {
            textZoomLevels[i] = ZOOM_FORMAT.format(this.zoomLevels[i]);
        }
        return textZoomLevels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getTextWidth(String string, Control control) {
        GC gc = new GC((Drawable)control);
        try {
            int n = gc.textExtent((String)string).x;
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    private Control createControl(Composite parent) {
        this.combo = new Combo(parent, 4);
        this.combo.addListener(13, (Listener)this);
        this.combo.addListener(14, (Listener)this);
        this.combo.addListener(15, (Listener)this);
        this.combo.setItems(new String[]{"8888%"});
        this.combo.pack();
        this.refresh();
        return this.combo;
    }

    @Override
    public void dispose() {
        this.viewer.removeReportViewerListener(this);
        this.combo = null;
        this.viewer = null;
    }

    @Override
    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    @Override
    public final void fill(Menu parent, int index) {
        Assert.isTrue(false, Messages.getString("ZoomComboContributionItem.cannotAddToMenu"));
    }

    @Override
    public void fill(ToolBar parent, int index) {
        ToolItem toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        toolitem.setWidth(this.combo.getSize().x);
        toolitem.setControl(control);
    }

    private void onSelection() {
        if (this.viewer.hasDocument()) {
            if (this.combo.getSelectionIndex() >= 0) {
                this.setZoomAsText(this.combo.getItem(this.combo.getSelectionIndex()));
            } else {
                this.setZoomAsText(this.combo.getText());
            }
        }
    }

    private void setZoomAsText(String zoomText) {
        int percentIndex = zoomText.indexOf(37);
        if (percentIndex != -1) {
            zoomText = zoomText.substring(0, percentIndex);
        }
        try {
            final float zoom = Float.parseFloat(zoomText) / 100.0f;
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ZoomComboContributionItem.this.viewer.setZoom(zoom);
                }
            });
        }
        catch (NumberFormatException e) {
            Display.getCurrent().beep();
        }
        this.combo.removeListener(13, (Listener)this);
        this.combo.removeListener(14, (Listener)this);
        String zoom = ZOOM_FORMAT.format(this.viewer.getZoom());
        int index = this.combo.indexOf(zoom);
        if (index != -1) {
            this.combo.select(index);
        } else {
            this.combo.setText(zoom);
        }
        this.combo.addListener(13, (Listener)this);
        this.combo.addListener(14, (Listener)this);
    }

    private String getZoomAsText() {
        return ZOOM_FORMAT.format(this.viewer.getZoom());
    }

    @Override
    public void viewerStateChanged(ReportViewerEvent evt) {
        this.refresh();
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.refresh();
                break;
            }
            case 13: 
            case 14: {
                this.onSelection();
            }
        }
    }
}

