/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.actions.Messages;
import java.text.MessageFormat;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitor;

class ProgressMonitorAdapter
implements JRExportProgressMonitor {
    private final IProgressMonitor monitor;
    private final int totalPages;
    private int currentPage = 1;

    ProgressMonitorAdapter(IProgressMonitor monitor, int totalPages) {
        this.monitor = monitor;
        this.totalPages = totalPages;
        this.updateSubtask();
    }

    @Override
    public void afterPageExport() {
        this.monitor.worked(1);
        if (++this.currentPage <= this.totalPages) {
            this.updateSubtask();
        }
        if (this.monitor.isCanceled()) {
            Thread.currentThread().interrupt();
        }
    }

    private void updateSubtask() {
        this.monitor.subTask(MessageFormat.format(Messages.getString("AbstractExportAction.pageMofN"), this.currentPage, this.totalPages));
    }
}

