/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.IReportViewerListener;
import com.jasperassistant.designer.viewer.ReportViewerEvent;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class PageNumberContributionItem
extends ContributionItem
implements IReportViewerListener,
Listener {
    private IReportViewer viewer;
    private Text text;

    public PageNumberContributionItem(IReportViewer viewer) {
        Assert.isNotNull(viewer);
        this.viewer = viewer;
        this.viewer.addReportViewerListener(this);
        this.refresh();
    }

    void refresh() {
        block5: {
            if (this.text == null || this.text.isDisposed()) {
                return;
            }
            try {
                if (!this.viewer.hasDocument()) {
                    this.text.setEnabled(false);
                    this.text.setText("");
                } else {
                    this.text.removeListener(14, (Listener)this);
                    this.text.setText(this.getPageMofNText());
                    this.text.setEnabled(true);
                    this.text.addListener(14, (Listener)this);
                }
            }
            catch (SWTException exception) {
                if (SWT.getPlatform().equals("gtk")) break block5;
                throw exception;
            }
        }
    }

    private Control createControl(Composite parent) {
        this.text = new Text(parent, 0x1000800);
        this.text.setText(PageNumberContributionItem.formatPageMofN(888, 888));
        this.text.addListener(14, (Listener)this);
        this.text.pack();
        this.refresh();
        return this.text;
    }

    private static String formatPageMofN(int m, int n) {
        return MessageFormat.format(Messages.getString("PageNumberContributionItem.pageMofN"), m, n);
    }

    @Override
    public void dispose() {
        this.viewer.removeReportViewerListener(this);
        this.text = null;
        this.viewer = null;
    }

    @Override
    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    @Override
    public final void fill(Menu parent, int index) {
        Assert.isTrue(false, "Can't add page number to a menu");
    }

    @Override
    public void fill(ToolBar parent, int index) {
        ToolItem toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        toolitem.setWidth(this.text.getSize().x);
        toolitem.setControl(control);
    }

    private void onSelection() {
        if (this.viewer.hasDocument()) {
            this.setPageAsText(this.text.getText());
        }
    }

    private void setPageAsText(String pageText) {
        try {
            final int pageIndex = Integer.parseInt(pageText) - 1;
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    PageNumberContributionItem.this.viewer.setPageIndex(pageIndex);
                }
            });
        }
        catch (NumberFormatException e) {
            Display.getCurrent().beep();
        }
        this.text.removeListener(14, (Listener)this);
        this.text.setText(this.getPageMofNText());
        this.text.addListener(14, (Listener)this);
    }

    private String getPageMofNText() {
        return PageNumberContributionItem.formatPageMofN(this.viewer.getPageIndex() + 1, this.viewer.getDocument().getPages().size());
    }

    @Override
    public void viewerStateChanged(ReportViewerEvent evt) {
        this.refresh();
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 13: 
            case 14: {
                this.onSelection();
            }
        }
    }
}

