/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.export.SimpleExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleReportExportConfiguration;
import net.sf.jasperreports.export.SimpleXmlExporterOutput;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExportAsXmlWithImagesAction
extends AbstractExportAction {
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(ExportAsXmlWithImagesAction.class, "images/save.gif");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(ExportAsXmlWithImagesAction.class, "images/saved.gif");

    public ExportAsXmlWithImagesAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("ExportAsXmlWithImagesAction.label"));
        this.setToolTipText(Messages.getString("ExportAsXmlWithImagesAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setFileExtensions(new String[]{"*.xml", "*.jrpxml"});
        this.setFilterNames(new String[]{Messages.getString("ExportAsXmlWithImagesAction.xmlFilterName"), Messages.getString("ExportAsXmlWithImagesAction.jrpxmlFilterName")});
        this.setDefaultFileExtension("xml");
    }

    @Override
    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        SimpleExporterInput exporterInput = new SimpleExporterInput(this.getReportViewer().getDocument());
        SimpleXmlExporterOutput exporterOutput = new SimpleXmlExporterOutput(file);
        exporterOutput.setEmbeddingImages(true);
        SimpleReportExportConfiguration reportExportConfiguration = new SimpleReportExportConfiguration();
        reportExportConfiguration.setProgressMonitor(monitor);
        SimpleExporterConfiguration exporterConfiguration = new SimpleExporterConfiguration();
        JRXmlExporter jrExporter = new JRXmlExporter();
        jrExporter.setExporterInput(exporterInput);
        jrExporter.setExporterOutput(exporterOutput);
        jrExporter.setConfiguration(reportExportConfiguration);
        jrExporter.setConfiguration(exporterConfiguration);
        jrExporter.exportReport();
    }
}

