/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.export.SimpleExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleReportExportConfiguration;
import net.sf.jasperreports.export.SimpleXmlExporterOutput;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExportAsXmlAction
extends AbstractExportAction {
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(ExportAsXmlAction.class, "images/save.gif");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(ExportAsXmlAction.class, "images/saved.gif");

    public ExportAsXmlAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("ExportAsXmlAction.label"));
        this.setToolTipText(Messages.getString("ExportAsXmlAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setFileExtensions(new String[]{"*.xml", "*.jrpxml"});
        this.setFilterNames(new String[]{Messages.getString("ExportAsXmlAction.xmlFilterName"), Messages.getString("ExportAsXmlAction.jrpxmlFilterName")});
        this.setDefaultFileExtension("xml");
    }

    @Override
    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        SimpleExporterInput exporterInput = new SimpleExporterInput(this.getReportViewer().getDocument());
        SimpleXmlExporterOutput exporterOutput = new SimpleXmlExporterOutput(file);
        exporterOutput.setEmbeddingImages(false);
        SimpleReportExportConfiguration reportExportConfiguration = new SimpleReportExportConfiguration();
        reportExportConfiguration.setProgressMonitor(monitor);
        SimpleExporterConfiguration exporterConfiguration = new SimpleExporterConfiguration();
        JRXmlExporter jrExporter = new JRXmlExporter();
        jrExporter.setExporterInput(exporterInput);
        jrExporter.setExporterOutput(exporterOutput);
        jrExporter.setConfiguration(reportExportConfiguration);
        jrExporter.setConfiguration(exporterConfiguration);
        jrExporter.exportReport();
    }
}

