/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsExporterConfiguration;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExportAsSingleXlsAction
extends AbstractExportAction {
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(ExportAsSingleXlsAction.class, "images/save.gif");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(ExportAsSingleXlsAction.class, "images/saved.gif");

    public ExportAsSingleXlsAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("ExportAsSingleXlsAction.label"));
        this.setToolTipText(Messages.getString("ExportAsSingleXlsAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setFileExtensions(new String[]{"*.xls"});
        this.setFilterNames(new String[]{Messages.getString("ExportAsSingleXlsAction.filterName")});
        this.setDefaultFileExtension("xls");
    }

    @Override
    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        SimpleExporterInput exporterInput = new SimpleExporterInput(this.getReportViewer().getDocument());
        SimpleOutputStreamExporterOutput exporterOutput = new SimpleOutputStreamExporterOutput(file);
        SimpleXlsReportConfiguration reportExportConfiguration = new SimpleXlsReportConfiguration();
        reportExportConfiguration.setOnePagePerSheet(false);
        SimpleXlsExporterConfiguration exporterConfiguration = new SimpleXlsExporterConfiguration();
        reportExportConfiguration.setProgressMonitor(monitor);
        JRXlsExporter jrExporter = new JRXlsExporter();
        jrExporter.setExporterInput(exporterInput);
        jrExporter.setExporterOutput(exporterOutput);
        jrExporter.setConfiguration(reportExportConfiguration);
        jrExporter.setConfiguration(exporterConfiguration);
        jrExporter.exportReport();
    }
}

