/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import com.jasperassistant.designer.viewer.actions.ExportAsPdfAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleRtfExporterConfiguration;
import net.sf.jasperreports.export.SimpleRtfReportConfiguration;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExportAsRtfAction
extends AbstractExportAction {
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(ExportAsPdfAction.class, "images/save.gif");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(ExportAsPdfAction.class, "images/saved.gif");

    public ExportAsRtfAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("ExportAsRtfAction.label"));
        this.setToolTipText(Messages.getString("ExportAsRtfAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setFileExtensions(new String[]{"*.rtf"});
        this.setFilterNames(new String[]{Messages.getString("ExportAsRtfAction.filterName")});
        this.setDefaultFileExtension("rtf");
    }

    @Override
    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        SimpleExporterInput exporterInput = new SimpleExporterInput(this.getReportViewer().getDocument());
        SimpleWriterExporterOutput exporterOutput = new SimpleWriterExporterOutput(file);
        SimpleRtfReportConfiguration reportExportConfiguration = new SimpleRtfReportConfiguration();
        reportExportConfiguration.setProgressMonitor(monitor);
        SimpleRtfExporterConfiguration exporterConfiguration = new SimpleRtfExporterConfiguration();
        JRRtfExporter jrExporter = new JRRtfExporter();
        jrExporter.setExporterInput(exporterInput);
        jrExporter.setExporterOutput(exporterOutput);
        jrExporter.setConfiguration(reportExportConfiguration);
        jrExporter.setConfiguration(exporterConfiguration);
        jrExporter.exportReport();
    }
}

