/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;
import net.sf.jasperreports.export.SimplePdfReportConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExportAsPdfAction
extends AbstractExportAction {
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(ExportAsPdfAction.class, "images/save.gif");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(ExportAsPdfAction.class, "images/saved.gif");

    public ExportAsPdfAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("ExportAsPdfAction.label"));
        this.setToolTipText(Messages.getString("ExportAsPdfAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setFileExtensions(new String[]{"*.pdf"});
        this.setFilterNames(new String[]{Messages.getString("ExportAsPdfAction.filterName")});
        this.setDefaultFileExtension("pdf");
    }

    @Override
    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        SimpleExporterInput exporterInput = new SimpleExporterInput(this.getReportViewer().getDocument());
        SimpleOutputStreamExporterOutput exporterOutput = new SimpleOutputStreamExporterOutput(file);
        SimplePdfReportConfiguration reportExportConfiguration = new SimplePdfReportConfiguration();
        reportExportConfiguration.setProgressMonitor(monitor);
        SimplePdfExporterConfiguration exporterConfiguration = new SimplePdfExporterConfiguration();
        JRPdfExporter jrExporter = new JRPdfExporter();
        jrExporter.setExporterInput(exporterInput);
        jrExporter.setExporterOutput(exporterOutput);
        jrExporter.setConfiguration(reportExportConfiguration);
        jrExporter.setConfiguration(exporterConfiguration);
        jrExporter.exportReport();
    }
}

