/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleCsvReportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExportAsCsvAction
extends AbstractExportAction {
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(ExportAsCsvAction.class, "images/save.gif");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(ExportAsCsvAction.class, "images/saved.gif");

    public ExportAsCsvAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("ExportAsCsvAction.label"));
        this.setToolTipText(Messages.getString("ExportAsCsvAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setFileExtensions(new String[]{"*.csv"});
        this.setFilterNames(new String[]{Messages.getString("ExportAsCsvAction.filterName")});
        this.setDefaultFileExtension("csv");
    }

    @Override
    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        SimpleExporterInput exporterInput = new SimpleExporterInput(this.getReportViewer().getDocument());
        SimpleWriterExporterOutput exporterOutput = new SimpleWriterExporterOutput(file);
        SimpleCsvReportConfiguration reportExportConfiguration = new SimpleCsvReportConfiguration();
        SimpleCsvExporterConfiguration exporterConfiguration = new SimpleCsvExporterConfiguration();
        reportExportConfiguration.setProgressMonitor(monitor);
        JRCsvExporter jrExporter = new JRCsvExporter();
        jrExporter.setExporterInput(exporterInput);
        jrExporter.setExporterOutput(exporterOutput);
        jrExporter.setConfiguration(reportExportConfiguration);
        jrExporter.setConfiguration(exporterConfiguration);
        jrExporter.exportReport();
    }
}

