/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer;

import com.jasperassistant.designer.viewer.DefaultHyperlinkHandler;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.Messages;
import com.jasperassistant.designer.viewer.ReportViewer;
import com.jasperassistant.designer.viewer.Sleak;
import com.jasperassistant.designer.viewer.StatusBar;
import com.jasperassistant.designer.viewer.actions.ExportAsCsvAction;
import com.jasperassistant.designer.viewer.actions.ExportAsHtmlAction;
import com.jasperassistant.designer.viewer.actions.ExportAsJasperReportsAction;
import com.jasperassistant.designer.viewer.actions.ExportAsMultiXlsAction;
import com.jasperassistant.designer.viewer.actions.ExportAsPdfAction;
import com.jasperassistant.designer.viewer.actions.ExportAsRtfAction;
import com.jasperassistant.designer.viewer.actions.ExportAsSingleXlsAction;
import com.jasperassistant.designer.viewer.actions.ExportAsXmlAction;
import com.jasperassistant.designer.viewer.actions.ExportAsXmlWithImagesAction;
import com.jasperassistant.designer.viewer.actions.ExportMenuAction;
import com.jasperassistant.designer.viewer.actions.FirstPageAction;
import com.jasperassistant.designer.viewer.actions.LastPageAction;
import com.jasperassistant.designer.viewer.actions.NextPageAction;
import com.jasperassistant.designer.viewer.actions.PageNumberContributionItem;
import com.jasperassistant.designer.viewer.actions.PreviousPageAction;
import com.jasperassistant.designer.viewer.actions.PrintAction;
import com.jasperassistant.designer.viewer.actions.ReloadAction;
import com.jasperassistant.designer.viewer.actions.ZoomActualSizeAction;
import com.jasperassistant.designer.viewer.actions.ZoomComboContributionItem;
import com.jasperassistant.designer.viewer.actions.ZoomFitPageAction;
import com.jasperassistant.designer.viewer.actions.ZoomFitPageWidthAction;
import com.jasperassistant.designer.viewer.actions.ZoomInAction;
import com.jasperassistant.designer.viewer.actions.ZoomOutAction;
import net.sf.jasperreports.view.JasperViewer;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class ViewerComposite
extends Composite {
    private ReportViewer reportViewer;

    public ViewerComposite(Composite parent, int style) {
        super(parent, style);
        this.createContents();
    }

    private void createContents() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 2;
        this.setLayout((Layout)layout);
        this.reportViewer = new ReportViewer(2048);
        ToolBarManager tbManager = new ToolBarManager(0x800000);
        ExportMenuAction exportMenu = new ExportMenuAction(this.reportViewer);
        ExportAsPdfAction pdfAction = null;
        pdfAction = new ExportAsPdfAction(this.reportViewer);
        exportMenu.getMenuManager().add(pdfAction);
        exportMenu.getMenuManager().add(new ExportAsRtfAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsJasperReportsAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsHtmlAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsSingleXlsAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsMultiXlsAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsCsvAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsXmlAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsXmlWithImagesAction(this.reportViewer));
        exportMenu.setDefaultAction(pdfAction);
        tbManager.add(exportMenu);
        tbManager.add(new PrintAction(this.reportViewer));
        tbManager.add(new ReloadAction(this.reportViewer));
        tbManager.add(new Separator());
        tbManager.add(new FirstPageAction(this.reportViewer));
        tbManager.add(new PreviousPageAction(this.reportViewer));
        if (SWT.getPlatform().equals("win32")) {
            tbManager.add(new PageNumberContributionItem(this.reportViewer));
        }
        tbManager.add(new NextPageAction(this.reportViewer));
        tbManager.add(new LastPageAction(this.reportViewer));
        tbManager.add(new Separator());
        tbManager.add(new ZoomActualSizeAction(this.reportViewer));
        tbManager.add(new ZoomFitPageAction(this.reportViewer));
        tbManager.add(new ZoomFitPageWidthAction(this.reportViewer));
        tbManager.add(new Separator());
        tbManager.add(new ZoomOutAction(this.reportViewer));
        tbManager.add(new ZoomComboContributionItem(this.reportViewer));
        tbManager.add(new ZoomInAction(this.reportViewer));
        ToolBar toolbar = tbManager.createControl(this);
        toolbar.setLayoutData((Object)new GridData(768));
        Control reportViewerControl = this.reportViewer.createControl(this);
        reportViewerControl.setLayoutData((Object)new GridData(1808));
        StatusBar statusBar = new StatusBar();
        statusBar.setReportViewer(this.reportViewer);
        Control statusBarControl = statusBar.createControl(this);
        statusBarControl.setLayoutData((Object)new GridData(768));
        this.reportViewer.addHyperlinkListener(new DefaultHyperlinkHandler());
    }

    public IReportViewer getReportViewer() {
        return this.reportViewer;
    }

    public static void main(String[] args) {
        String fileName = null;
        boolean isXMLFile = false;
        if (args.length == 0) {
            ViewerComposite.usage();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-F")) {
                fileName = args[i].substring(2);
            }
            if (!args[i].startsWith("-XML")) continue;
            isXMLFile = true;
        }
        if (fileName == null) {
            ViewerComposite.usage();
            return;
        }
        ViewerComposite.openViewer(fileName, isXMLFile);
        System.exit(0);
    }

    private static void openViewer(String fileName, boolean isXMLFile) {
        Display display = null;
        if (Boolean.getBoolean("swtdebug")) {
            DeviceData data = new DeviceData();
            data.tracking = true;
            data.debug = true;
            display = new Display(data);
            Sleak sleak = new Sleak();
            sleak.open();
        } else {
            display = new Display();
        }
        Shell shell = new Shell(display);
        shell.setText(Messages.getString("ViewerComposite.label"));
        shell.setLayout((Layout)new FillLayout());
        shell.setImage(new Image(null, JasperViewer.class.getResourceAsStream("images/jricon.GIF")));
        ViewerComposite viewer = new ViewerComposite((Composite)shell, 0);
        viewer.getReportViewer().loadDocument(fileName, isXMLFile);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void usage() {
        System.out.println(Messages.getString("ViewerComposite.usageLabel"));
        System.out.println(Messages.getString("ViewerComposite.usage"));
    }
}

