/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer;

import com.jasperassistant.designer.viewer.DefaultHyperlinkHandler;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.Messages;
import com.jasperassistant.designer.viewer.ReportViewer;
import com.jasperassistant.designer.viewer.StatusBar;
import com.jasperassistant.designer.viewer.actions.ExportAsCsvAction;
import com.jasperassistant.designer.viewer.actions.ExportAsHtmlAction;
import com.jasperassistant.designer.viewer.actions.ExportAsJasperReportsAction;
import com.jasperassistant.designer.viewer.actions.ExportAsMultiXlsAction;
import com.jasperassistant.designer.viewer.actions.ExportAsPdfAction;
import com.jasperassistant.designer.viewer.actions.ExportAsRtfAction;
import com.jasperassistant.designer.viewer.actions.ExportAsSingleXlsAction;
import com.jasperassistant.designer.viewer.actions.ExportAsXmlAction;
import com.jasperassistant.designer.viewer.actions.ExportAsXmlWithImagesAction;
import com.jasperassistant.designer.viewer.actions.ExportMenuAction;
import com.jasperassistant.designer.viewer.actions.FirstPageAction;
import com.jasperassistant.designer.viewer.actions.LastPageAction;
import com.jasperassistant.designer.viewer.actions.NextPageAction;
import com.jasperassistant.designer.viewer.actions.PageNumberContributionItem;
import com.jasperassistant.designer.viewer.actions.PreviousPageAction;
import com.jasperassistant.designer.viewer.actions.PrintAction;
import com.jasperassistant.designer.viewer.actions.ReloadAction;
import com.jasperassistant.designer.viewer.actions.ZoomActualSizeAction;
import com.jasperassistant.designer.viewer.actions.ZoomComboContributionItem;
import com.jasperassistant.designer.viewer.actions.ZoomFitPageAction;
import com.jasperassistant.designer.viewer.actions.ZoomFitPageWidthAction;
import com.jasperassistant.designer.viewer.actions.ZoomInAction;
import com.jasperassistant.designer.viewer.actions.ZoomOutAction;
import net.sf.jasperreports.view.JasperViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ViewerApp
extends ApplicationWindow {
    private final ReportViewer reportViewer = new ReportViewer(2048);

    public ViewerApp() {
        super((Shell)null);
        this.addToolBar(0x800040);
        this.addMenuBar();
        this.setBlockOnOpen(true);
        this.initMenu();
        this.initToolBar();
    }

    private void initMenu() {
        MenuManager mm = this.getMenuBarManager();
        MenuManager export = new MenuManager(Messages.getString("ViewerApp.exportMenuLabel"));
        export.add(new ExportAsPdfAction(this.reportViewer));
        export.add(new ExportAsRtfAction(this.reportViewer));
        export.add(new ExportAsJasperReportsAction(this.reportViewer));
        export.add(new ExportAsHtmlAction(this.reportViewer));
        export.add(new ExportAsSingleXlsAction(this.reportViewer));
        export.add(new ExportAsMultiXlsAction(this.reportViewer));
        export.add(new ExportAsCsvAction(this.reportViewer));
        export.add(new ExportAsXmlAction(this.reportViewer));
        export.add(new ExportAsXmlWithImagesAction(this.reportViewer));
        MenuManager file = new MenuManager(Messages.getString("ViewerApp.fileMenuLabel"));
        file.add(new ReloadAction(this.reportViewer));
        file.add(new Separator());
        file.add(export);
        file.add(new Separator());
        file.add(new PrintAction(this.reportViewer));
        mm.add(file);
        MenuManager view = new MenuManager(Messages.getString("ViewerApp.viewMenuLabel"));
        view.add(new ZoomOutAction(this.reportViewer));
        view.add(new ZoomInAction(this.reportViewer));
        view.add(new Separator());
        view.add(new ZoomActualSizeAction(this.reportViewer));
        view.add(new ZoomFitPageAction(this.reportViewer));
        view.add(new ZoomFitPageWidthAction(this.reportViewer));
        mm.add(view);
        MenuManager nav = new MenuManager(Messages.getString("ViewerApp.navigateMenuLabel"));
        nav.add(new FirstPageAction(this.reportViewer));
        nav.add(new PreviousPageAction(this.reportViewer));
        nav.add(new NextPageAction(this.reportViewer));
        nav.add(new LastPageAction(this.reportViewer));
        mm.add(nav);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ViewerApp.title"));
        shell.setImage(new Image(null, JasperViewer.class.getResourceAsStream("images/jricon.GIF")));
    }

    private void initToolBar() {
        ToolBarManager tbManager = this.getToolBarManager();
        ExportMenuAction exportMenu = new ExportMenuAction(this.reportViewer);
        ExportAsPdfAction pdfAction = null;
        pdfAction = new ExportAsPdfAction(this.reportViewer);
        exportMenu.getMenuManager().add(pdfAction);
        exportMenu.getMenuManager().add(new ExportAsRtfAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsJasperReportsAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsHtmlAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsSingleXlsAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsMultiXlsAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsCsvAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsXmlAction(this.reportViewer));
        exportMenu.getMenuManager().add(new ExportAsXmlWithImagesAction(this.reportViewer));
        exportMenu.setDefaultAction(pdfAction);
        tbManager.add(exportMenu);
        tbManager.add(new PrintAction(this.reportViewer));
        tbManager.add(new ReloadAction(this.reportViewer));
        tbManager.add(new Separator());
        tbManager.add(new FirstPageAction(this.reportViewer));
        tbManager.add(new PreviousPageAction(this.reportViewer));
        if (SWT.getPlatform().equals("win32")) {
            tbManager.add(new PageNumberContributionItem(this.reportViewer));
        }
        tbManager.add(new NextPageAction(this.reportViewer));
        tbManager.add(new LastPageAction(this.reportViewer));
        tbManager.add(new Separator());
        tbManager.add(new ZoomActualSizeAction(this.reportViewer));
        tbManager.add(new ZoomFitPageAction(this.reportViewer));
        tbManager.add(new ZoomFitPageWidthAction(this.reportViewer));
        tbManager.add(new Separator());
        tbManager.add(new ZoomOutAction(this.reportViewer));
        tbManager.add(new ZoomComboContributionItem(this.reportViewer));
        tbManager.add(new ZoomInAction(this.reportViewer));
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        Control reportViewerControl = this.reportViewer.createControl(container);
        reportViewerControl.setLayoutData((Object)new GridData(1808));
        StatusBar statusBar = new StatusBar();
        statusBar.setReportViewer(this.reportViewer);
        Control statusBarControl = statusBar.createControl(container);
        statusBarControl.setLayoutData((Object)new GridData(768));
        this.reportViewer.addHyperlinkListener(new DefaultHyperlinkHandler());
        return container;
    }

    public IReportViewer getReportViewer() {
        return this.reportViewer;
    }

    public static void main(String[] args) {
        String fileName = null;
        boolean isXMLFile = false;
        if (args.length == 0) {
            ViewerApp.usage();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-F")) {
                fileName = args[i].substring(2);
            }
            if (!args[i].startsWith("-XML")) continue;
            isXMLFile = true;
        }
        if (fileName == null) {
            ViewerApp.usage();
            return;
        }
        ViewerApp.openViewer(fileName, isXMLFile);
        System.exit(0);
    }

    private static void openViewer(String fileName, boolean isXMLFile) {
        ViewerApp app = new ViewerApp();
        app.getReportViewer().loadDocument(fileName, isXMLFile);
        app.open();
    }

    private static void usage() {
        System.out.println(Messages.getString("ViewerApp.usageLabel"));
        System.out.println(Messages.getString("ViewerApp.usage"));
    }
}

