/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.IReportViewerAware;
import com.jasperassistant.designer.viewer.IReportViewerListener;
import com.jasperassistant.designer.viewer.Messages;
import com.jasperassistant.designer.viewer.ReportViewerEvent;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class StatusBar
implements IReportViewerAware {
    private IReportViewer viewer;
    private int style = 0x1000000;
    private Label label;
    private final IReportViewerListener listener = new IReportViewerListener(){

        @Override
        public void viewerStateChanged(ReportViewerEvent evt) {
            StatusBar.this.refresh();
        }
    };

    public StatusBar() {
    }

    public StatusBar(int style) {
        this.style = style;
    }

    public Control createControl(Composite parent) {
        if (this.label == null) {
            this.label = new Label(parent, this.style);
            this.refresh();
        }
        return this.label;
    }

    private void refresh() {
        if (this.label == null || this.label.isDisposed()) {
            return;
        }
        if (this.viewer == null || !this.viewer.hasDocument()) {
            this.label.setText("");
        } else {
            this.label.setText(MessageFormat.format(Messages.getString("StatusBar.pageMofN"), this.viewer.getPageIndex() + 1, this.viewer.getDocument().getPages().size()));
        }
    }

    @Override
    public void setReportViewer(IReportViewer viewer) {
        if (viewer != null) {
            viewer.removeReportViewerListener(this.listener);
        }
        this.viewer = viewer;
        if (viewer != null) {
            viewer.addReportViewerListener(this.listener);
        }
        this.refresh();
    }

    @Override
    public IReportViewer getReportViewer() {
        return this.viewer;
    }
}

