/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class Sleak {
    Display display;
    Shell shell;
    org.eclipse.swt.widgets.List list;
    Canvas canvas;
    Button start;
    Button stop;
    Button check;
    Text text;
    Label label;
    Object[] oldObjects = new Object[0];
    Error[] oldErrors = new Error[0];
    Object[] objects = new Object[0];
    Error[] errors = new Error[0];

    Sleak() {
    }

    public void open() {
        this.display = Display.getCurrent();
        this.shell = new Shell(this.display);
        this.shell.setText("S-Leak");
        this.list = new org.eclipse.swt.widgets.List((Composite)this.shell, 2560);
        this.list.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.refreshObject();
            }
        });
        this.text = new Text((Composite)this.shell, 2816);
        this.canvas = new Canvas((Composite)this.shell, 2048);
        this.canvas.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.paintCanvas(event);
            }
        });
        this.check = new Button((Composite)this.shell, 32);
        this.check.setText("Stack");
        this.check.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Sleak.this.toggleStackTrace();
            }
        });
        this.start = new Button((Composite)this.shell, 8);
        this.start.setText("Snap");
        this.start.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.refreshAll();
            }
        });
        this.stop = new Button((Composite)this.shell, 8);
        this.stop.setText("Diff");
        this.stop.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.refreshDifference();
            }
        });
        this.label = new Label((Composite)this.shell, 2048);
        this.label.setText("0 object(s)");
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Sleak.this.layout();
            }
        });
        this.check.setSelection(false);
        this.text.setVisible(false);
        Point size = this.shell.getSize();
        this.shell.setSize(size.x / 2, size.y / 2);
        this.shell.open();
    }

    void refreshLabel() {
        int colors = 0;
        int cursors = 0;
        int fonts = 0;
        int gcs = 0;
        int images = 0;
        for (int i = 0; i < this.objects.length; ++i) {
            Object object = this.objects[i];
            if (object instanceof Color) {
                ++colors;
            }
            if (object instanceof Cursor) {
                ++cursors;
            }
            if (object instanceof Font) {
                ++fonts;
            }
            if (object instanceof GC) {
                ++gcs;
            }
            if (!(object instanceof Image)) continue;
            ++images;
        }
        String string = "";
        if (colors != 0) {
            string = string + colors + " Color(s)\n";
        }
        if (cursors != 0) {
            string = string + cursors + " Cursor(s)\n";
        }
        if (fonts != 0) {
            string = string + fonts + " Font(s)\n";
        }
        if (gcs != 0) {
            string = string + gcs + " GC(s)\n";
        }
        if (images != 0) {
            string = string + images + " Image(s)\n";
        }
        if (string.length() != 0) {
            string = string.substring(0, string.length() - 1);
        }
        this.label.setText(string);
    }

    void refreshDifference() {
        int i;
        DeviceData info = this.display.getDeviceData();
        if (!info.tracking) {
            MessageBox dialog = new MessageBox(this.shell, 40);
            dialog.setText(this.shell.getText());
            dialog.setMessage("Warning: Device is not tracking resource allocation");
            dialog.open();
        }
        Object[] newObjects = this.findObjects(info);
        Error[] newErrors = new Error[newObjects.length];
        System.arraycopy(info.errors, 0, newErrors, 0, info.errors.length);
        Object[] diffObjects = new Object[newObjects.length];
        Error[] diffErrors = new Error[newObjects.length];
        int count = 0;
        for (i = 0; i < newObjects.length; ++i) {
            int index;
            for (index = 0; index < this.oldObjects.length && newObjects[i] != this.oldObjects[index]; ++index) {
            }
            if (index != this.oldObjects.length) continue;
            diffObjects[count] = newObjects[i];
            diffErrors[count] = newErrors[i];
            ++count;
        }
        this.objects = new Object[count];
        this.errors = new Error[count];
        System.arraycopy(diffObjects, 0, this.objects, 0, count);
        System.arraycopy(diffErrors, 0, this.errors, 0, count);
        this.list.removeAll();
        this.text.setText("");
        this.canvas.redraw();
        for (i = 0; i < this.objects.length; ++i) {
            this.list.add(this.objectName(this.objects[i]));
        }
        this.refreshLabel();
        this.layout();
    }

    private Object[] findObjects(DeviceData info) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = 0; i < info.objects.length; ++i) {
            objects.add(info.objects[i]);
        }
        Shell[] shells = this.display.getShells();
        for (int i = 0; i < shells.length; ++i) {
            this.findWidgets(objects, (Widget)shells[i]);
        }
        return objects.toArray();
    }

    private void findWidgets(List<Object> objects, Widget widget) {
        objects.add(widget);
        if (widget instanceof Composite) {
            Composite comp = (Composite)widget;
            Control[] children = comp.getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.findWidgets(objects, (Widget)children[i]);
            }
        }
    }

    String objectName(Object object) {
        String string = object.toString();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    void toggleStackTrace() {
        this.refreshObject();
        this.layout();
    }

    void paintCanvas(Event event) {
        this.canvas.setCursor(null);
        int index = this.list.getSelectionIndex();
        if (index == -1) {
            return;
        }
        GC gc = event.gc;
        Object object = this.objects[index];
        if (object instanceof Color) {
            if (((Color)object).isDisposed()) {
                return;
            }
            gc.setBackground((Color)object);
            gc.fillRectangle(this.canvas.getClientArea());
            return;
        }
        if (object instanceof Cursor) {
            if (((Cursor)object).isDisposed()) {
                return;
            }
            this.canvas.setCursor((Cursor)object);
            return;
        }
        if (object instanceof Font) {
            if (((Font)object).isDisposed()) {
                return;
            }
            gc.setFont((Font)object);
            FontData[] array = gc.getFont().getFontData();
            StringBuilder string = new StringBuilder();
            String lf = this.text.getLineDelimiter();
            for (int i = 0; i < array.length; ++i) {
                FontData data = array[i];
                String style = "NORMAL";
                int bits = data.getStyle();
                if (bits != 0) {
                    if ((bits & 1) != 0) {
                        style = "BOLD ";
                    }
                    if ((bits & 2) != 0) {
                        style = style + "ITALIC";
                    }
                }
                string.append(data.getName()).append(" ").append(data.getHeight()).append(" ").append(style).append(lf);
            }
            gc.drawString(string.toString(), 0, 0);
            return;
        }
        if (object instanceof Image) {
            if (((Image)object).isDisposed()) {
                return;
            }
            gc.drawImage((Image)object, 0, 0);
            return;
        }
        if (object instanceof Region) {
            if (((Region)object).isDisposed()) {
                return;
            }
            String string = ((Region)object).getBounds().toString();
            gc.drawString(string, 0, 0);
            return;
        }
    }

    void refreshObject() {
        int index = this.list.getSelectionIndex();
        if (index == -1) {
            return;
        }
        if (this.check.getSelection()) {
            if (this.errors[index] != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                PrintStream s = new PrintStream(stream);
                this.errors[index].printStackTrace(s);
                this.text.setText(stream.toString());
                this.text.setVisible(true);
                this.canvas.setVisible(false);
            } else if (this.objects[index] instanceof Control) {
                Control c = (Control)this.objects[index];
                StringBuffer buf = new StringBuffer();
                while (c != null) {
                    buf.insert(0, this.objectName(c));
                    if ((c = c.getParent()) == null) continue;
                    buf.insert(0, '/');
                }
                this.text.setText(buf.toString());
                this.text.setVisible(true);
                this.canvas.setVisible(false);
            } else {
                this.canvas.setVisible(true);
                this.text.setVisible(false);
                this.canvas.redraw();
            }
        } else {
            this.canvas.setVisible(true);
            this.text.setVisible(false);
            this.canvas.redraw();
        }
    }

    void refreshAll() {
        this.oldObjects = new Object[0];
        this.oldErrors = new Error[0];
        this.refreshDifference();
        this.oldObjects = this.objects;
        this.oldErrors = this.errors;
    }

    void layout() {
        Rectangle rect = this.shell.getClientArea();
        int width = 0;
        String[] items = this.list.getItems();
        GC gc = new GC((Drawable)this.list);
        for (int i = 0; i < this.objects.length; ++i) {
            width = Math.max(width, gc.stringExtent((String)items[i]).x);
        }
        gc.dispose();
        Point size1 = this.start.computeSize(-1, -1);
        Point size2 = this.stop.computeSize(-1, -1);
        Point size3 = this.check.computeSize(-1, -1);
        Point size4 = this.label.computeSize(-1, -1);
        width = Math.max(size1.x, Math.max(size2.x, Math.max(size3.x, width)));
        width = Math.max(64, Math.max(size4.x, this.list.computeSize((int)width, (int)-1).x));
        this.start.setBounds(0, 0, width, size1.y);
        this.stop.setBounds(0, size1.y, width, size2.y);
        this.check.setBounds(0, size1.y + size2.y, width, size3.y);
        this.label.setBounds(0, rect.height - size4.y, width, size4.y);
        int height = size1.y + size2.y + size3.y;
        this.list.setBounds(0, height, width, rect.height - height - size4.y);
        this.text.setBounds(width, 0, rect.width - width, rect.height);
        this.canvas.setBounds(width, 0, rect.width - width, rect.height);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Sleak sleak = new Sleak();
        sleak.open();
        while (!sleak.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

