/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.IReportViewerListener;
import com.jasperassistant.designer.viewer.Messages;
import com.jasperassistant.designer.viewer.ReportViewerEvent;
import com.jasperassistant.designer.viewer.ViewerCanvas;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRPrintXmlLoader;
import net.sf.jasperreports.view.JRHyperlinkListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ReportViewer
implements IReportViewer {
    private static final double[] DEFAULT_ZOOM_LEVELS = new double[]{0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0};
    private final EventListenerList listenerList = new EventListenerList();
    private JasperPrint document;
    private String reason;
    private double zoom = 1.0;
    private double[] zoomLevels = DEFAULT_ZOOM_LEVELS;
    private int zoomMode = 0;
    private int pageIndex;
    private String fileName;
    private boolean xml;
    private final int style;
    private ViewerCanvas viewerComposite;
    private List<JRHyperlinkListener> hyperlinkListeners;

    public ReportViewer() {
        this(0);
    }

    public ReportViewer(int style) {
        this.style = style;
    }

    @Override
    public void setDocument(JasperPrint document) {
        Assert.isNotNull(document, Messages.getString("ReportViewer.documentNotNull"));
        Assert.isNotNull(document.getPages(), Messages.getString("ReportViewer.documentNotEmpty"));
        Assert.isTrue(!document.getPages().isEmpty(), Messages.getString("ReportViewer.documentNotEmpty"));
        this.document = document;
        this.reason = null;
        this.pageIndex = Math.min(Math.max(0, this.pageIndex), this.getPageCount() - 1);
        this.setZoomInternal(this.computeZoom());
        this.fireViewerModelChanged();
    }

    @Override
    public JasperPrint getDocument() {
        return this.document;
    }

    @Override
    public boolean hasDocument() {
        return this.getDocument() != null;
    }

    @Override
    public void unsetDocument(String reason) {
        this.document = null;
        this.reason = reason;
        this.fireViewerModelChanged();
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void setZoom(double zoom) {
        this.setZoom(zoom, false);
    }

    private void setZoom(double zoom, boolean keepMode) {
        if (!this.canChangeZoom()) {
            return;
        }
        if (Math.abs(zoom - this.getZoom()) > 1.0E-5) {
            this.setZoomInternal(zoom);
            if (!keepMode) {
                this.zoomMode = 0;
            }
            this.fireViewerModelChanged();
        }
    }

    @Override
    public boolean canChangeZoom() {
        return this.hasDocument();
    }

    private void setZoomInternal(double zoom) {
        this.zoom = Math.min(Math.max(zoom, this.getMinZoom()), this.getMaxZoom());
    }

    @Override
    public double getZoom() {
        return this.zoom;
    }

    @Override
    public void setZoomMode(int zoomMode) {
        if (!this.canChangeZoom()) {
            return;
        }
        if (zoomMode != this.getZoomMode()) {
            this.zoomMode = zoomMode;
            this.setZoomInternal(this.computeZoom());
            this.fireViewerModelChanged();
        }
    }

    private double computeZoom() {
        switch (this.zoomMode) {
            case 1: {
                return 1.0;
            }
            case 2: {
                double ratio = this.ratio(this.viewerComposite.getFitSize().x, this.document.getPageWidth());
                return this.ratio(this.viewerComposite.getFitSize((int)((int)((double)this.document.getPageWidth() * ratio)), (int)((int)((double)this.document.getPageHeight() * ratio))).x, this.document.getPageWidth());
            }
            case 3: {
                double ratio = this.ratio(this.viewerComposite.getFitSize().y, this.document.getPageHeight());
                return this.ratio(this.viewerComposite.getFitSize((int)((int)((double)this.document.getPageWidth() * ratio)), (int)((int)((double)this.document.getPageHeight() * ratio))).y, this.document.getPageHeight());
            }
            case 4: {
                Point fitSize = this.viewerComposite.getFitSize();
                return Math.min(this.ratio(fitSize.x, this.document.getPageWidth()), this.ratio(fitSize.y, this.document.getPageHeight()));
            }
        }
        return this.zoom;
    }

    private double ratio(int a, int b) {
        return (double)(a * 100 / b) / 100.0;
    }

    @Override
    public int getZoomMode() {
        return this.zoomMode;
    }

    private int getPageCount() {
        return this.document == null ? 0 : this.document.getPages().size();
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void setPageIndex(int pageIndex) {
        if (pageIndex != this.getPageIndex()) {
            this.pageIndex = Math.min(Math.max(0, pageIndex), this.getPageCount() - 1);
            this.fireViewerModelChanged();
        }
    }

    @Override
    public boolean canGotoFirstPage() {
        return this.hasDocument() && this.pageIndex > 0;
    }

    @Override
    public void gotoFirstPage() {
        if (this.canGotoFirstPage()) {
            this.setPageIndex(0);
        }
    }

    @Override
    public boolean canGotoLastPage() {
        return this.hasDocument() && this.pageIndex < this.getPageCount() - 1;
    }

    @Override
    public void gotoLastPage() {
        if (this.canGotoLastPage()) {
            this.setPageIndex(this.getPageCount() - 1);
        }
    }

    @Override
    public boolean canGotoNextPage() {
        return this.hasDocument() && this.pageIndex < this.getPageCount() - 1;
    }

    @Override
    public void gotoNextPage() {
        if (this.canGotoNextPage()) {
            this.setPageIndex(this.pageIndex + 1);
        }
    }

    @Override
    public boolean canGotoPreviousPage() {
        return this.hasDocument() && this.pageIndex > 0;
    }

    @Override
    public void gotoPreviousPage() {
        if (this.canGotoPreviousPage()) {
            this.setPageIndex(this.pageIndex - 1);
        }
    }

    @Override
    public void addReportViewerListener(IReportViewerListener listener) {
        this.listenerList.add(IReportViewerListener.class, listener);
    }

    @Override
    public void removeReportViewerListener(IReportViewerListener listener) {
        this.listenerList.remove(IReportViewerListener.class, listener);
    }

    private void fireViewerModelChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ReportViewerEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IReportViewerListener.class) continue;
            if (e == null) {
                e = new ReportViewerEvent(this);
            }
            ((IReportViewerListener)listeners[i + 1]).viewerStateChanged(e);
        }
    }

    @Override
    public void reload() {
        try {
            this.pageIndex = 0;
            this.setDocument(this.load());
        }
        catch (JRException e) {
            this.unsetDocument(e.toString());
        }
    }

    @Override
    public boolean canReload() {
        return this.fileName != null;
    }

    @Override
    public void loadDocument(String fileName, boolean xml) {
        this.fileName = fileName;
        this.xml = xml;
        this.reload();
    }

    private JasperPrint load() throws JRException {
        JasperPrint jasperPrint = null;
        jasperPrint = this.xml ? JRPrintXmlLoader.load(this.fileName) : (JasperPrint)JRLoader.loadObjectFromFile(this.fileName);
        return jasperPrint;
    }

    public Control createControl(Composite parent) {
        if (this.viewerComposite == null) {
            this.viewerComposite = new ViewerCanvas(parent, this.style){

                @Override
                protected void resize() {
                    ReportViewer.this.setZoom(ReportViewer.this.computeZoom(), true);
                    super.resize();
                }
            };
            this.viewerComposite.setReportViewer(this);
        }
        return this.viewerComposite;
    }

    @Override
    public double[] getZoomLevels() {
        return this.zoomLevels;
    }

    @Override
    public void setZoomLevels(double[] levels) {
        Assert.isNotNull(levels);
        Assert.isTrue(levels.length > 0);
        this.zoomLevels = levels;
    }

    @Override
    public void zoomIn() {
        if (this.canZoomIn()) {
            this.setZoom(this.getNextZoom());
        }
    }

    @Override
    public boolean canZoomIn() {
        return this.hasDocument() && this.getZoom() < this.getMaxZoom();
    }

    @Override
    public void zoomOut() {
        if (this.canZoomOut()) {
            this.setZoom(this.getPreviousZoom());
        }
    }

    @Override
    public boolean canZoomOut() {
        return this.hasDocument() && this.getZoom() > this.getMinZoom();
    }

    private double getMinZoom() {
        return this.zoomLevels[0];
    }

    private double getMaxZoom() {
        return this.zoomLevels[this.zoomLevels.length - 1];
    }

    private double getNextZoom() {
        for (int i = 0; i < this.zoomLevels.length; ++i) {
            if (!(this.zoom < this.zoomLevels[i])) continue;
            return this.zoomLevels[i];
        }
        return this.getMaxZoom();
    }

    private double getPreviousZoom() {
        for (int i = this.zoomLevels.length - 1; i >= 0; --i) {
            if (!(this.zoom > this.zoomLevels[i])) continue;
            return this.zoomLevels[i];
        }
        return this.getMinZoom();
    }

    @Override
    public void addHyperlinkListener(JRHyperlinkListener listener) {
        if (this.hyperlinkListeners == null) {
            this.hyperlinkListeners = new ArrayList<JRHyperlinkListener>();
        } else {
            this.hyperlinkListeners.remove(listener);
        }
        this.hyperlinkListeners.add(listener);
    }

    @Override
    public void removeHyperlinkListener(JRHyperlinkListener listener) {
        if (this.hyperlinkListeners != null) {
            this.hyperlinkListeners.remove(listener);
        }
    }

    @Override
    public JRHyperlinkListener[] getHyperlinkListeners() {
        return this.hyperlinkListeners == null ? new JRHyperlinkListener[]{} : this.hyperlinkListeners.toArray(new JRHyperlinkListener[this.hyperlinkListeners.size()]);
    }
}

